/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.def.impl;

import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.ExtensionDefinition;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.def.ProcessStateUpdate;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

/**
 * @author Gael Lalire
 */
@XmlRootElement(name = "process")
public class ProcessDefinitionImpl extends ScopeActivityDefinitionImpl implements ProcessDefinition {

  private static final long serialVersionUID = 35906774703995610L;

  @XmlElement
  protected String nameSpace;
  @XmlElement
  protected String expressionLanguage;
  @XmlElement
  protected String queryLanguage;
  @XmlElement
  protected Date deployedDate;
  @XmlElement
  protected Date undeployedDate;
  @XmlElement
  protected ProcessState state;
  @XmlElementWrapper
  @XmlAnyElement(lax = true)
  protected List<ProcessStateUpdate> stateUpdates;
  @XmlElementWrapper
  protected Collection<String> resourceNames;
  @XmlElement
  protected int version;

  protected List<ExtensionDefinition> extensions = null;

  protected ProcessDefinitionImpl() {
  }

  public ProcessDefinitionImpl(final ProcessDefinition src) {
    super(src);
    this.enclosedActivityUUID = src.getEnclosedActivityUUID();
    this.nameSpace = src.getNameSpace();
    this.expressionLanguage = src.getExpressionLanguage();
    this.queryLanguage = src.getQueryLanguage();
    this.deployedDate = src.getDeployedDate();
    this.undeployedDate = src.getUndeployedDate();
    this.state = src.getState();
    this.stateUpdates = CopyUtil.copyList(src.getStateUpdates());
    this.version = src.getVersion();
    this.resourceNames = new HashSet<String>(src.getProcessResourceNames());
    this.extensions = CopyUtil.copyList(src.getExtensions());
  }

  @Override
  public boolean equals(final Object obj) {
    if (obj == null) {
      return false;
    }
    if (!(obj.getClass().equals(this.getClass()))) {
      return false;
    }
    final ProcessDefinitionImpl other = (ProcessDefinitionImpl) obj;
    return other.getUUID().equals(this.getUUID());
  }

  @Override
  public ProcessDefinitionUUID getUUID() {
    return this.getProcessDefinitionUUID();
  }

  @Override
  public int hashCode() {
    return this.getUUID().hashCode();
  }

  /**
   * @return the enclosedActivityUUID
   */
  @Override
  public ActivityDefinitionUUID getEnclosedActivityUUID() {
    return this.enclosedActivityUUID;
  }

  /**
   * @param enclosedActivityUUID the enclosedActivityUUID to set
   */
  public void setEnclosedActivityUUID(final ActivityDefinitionUUID enclosedActivityUUID) {
    this.enclosedActivityUUID = enclosedActivityUUID;
  }

  public String getNameSpace() {
    return this.nameSpace;
  }

  public String getExpressionLanguage() {
    return this.expressionLanguage;
  }

  public String getQueryLanguage() {
    return this.queryLanguage;
  }

  public Date getDeployedDate() {
    return this.deployedDate != null ? new Date(this.deployedDate.getTime()) : null;
  }

  public Date getUndeployedDate() {
    return this.undeployedDate != null ? new Date(this.undeployedDate.getTime()) : null;
  }

  @Override
  public ActivityType getType() {
    return ActivityType.PROCESS;
  }

  public QName getQName() {
    return new QName(this.getNameSpace(), this.getName());
  }

  public ProcessState getState() {
    return this.state;
  }

  public List<ProcessStateUpdate> getStateUpdates() {
    return this.stateUpdates;
  }

  public Collection<String> getProcessResourceNames() {
    return this.resourceNames;
  }

  public int getVersion() {
    return this.version;
  }

  public List<ExtensionDefinition> getExtensions() {
    return this.extensions;
  }
}
