/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime.impl;

import org.ow2.orchestra.facade.runtime.CorrelationSetInitialization;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.util.JAXBUtils;
import org.w3c.dom.Node;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

/**
 *
 * @author Gael Lalire
 */
@XmlRootElement(name = "correlationSetInitialisation")
public class CorrelationSetInitializationImpl implements CorrelationSetInitialization {

  private static final long serialVersionUID = -2069580133901045271L;

  @XmlElement
  private ActivityInstanceUUID activityUUID;
  @XmlElement
  private Date date;
  @XmlElement
  private String name;
  @XmlElement
  @XmlJavaTypeAdapter(JAXBUtils.JAXBMapNodeAdapter.class)
  protected Map<QName, Node> propertyValues;

  public CorrelationSetInitializationImpl() {}

  public CorrelationSetInitializationImpl(final CorrelationSetInitialization record) {
    this.activityUUID = record.getActivityUUID();
    this.date = new Date(record.getDate().getTime());
    this.name = record.getName();
    this.propertyValues = new HashMap<QName, Node>();
    for (final Entry<QName, Node> entry : record.getPropertyValues().entrySet()) {
      this.propertyValues.put(entry.getKey(), entry.getValue().cloneNode(true));
    }
  }

  public ActivityInstanceUUID getActivityUUID() {
    return this.activityUUID;
  }

  public Date getDate() {
    return new Date(this.date.getTime());
  }

  public String getName() {
    return this.name;
  }

  public Map<QName, Node> getPropertyValues() {
    return this.propertyValues;
  }

  public CorrelationSetInitialization copy() {
    return new CorrelationSetInitializationImpl(this);
  }

}
