/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;
import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.AssignActivityDefinition;
import org.ow2.orchestra.facade.def.CopyDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;

/**
 *
 * @author Alfonso Fuca
 */
@XmlRootElement(name = "assign")
public class AssignActivityDefinitionImpl extends BpelActivityDefinitionImpl implements AssignActivityDefinition {

  private static final long serialVersionUID = -8258323650177706915L;

  private boolean validate;

  private List<CopyDefinition> copyDefinitions;

  private AssignActivityDefinitionImpl() { }

  public AssignActivityDefinitionImpl(final AssignActivityDefinition src) {
    super(src);
    this.validate = src.isValidate();
    this.copyDefinitions = CopyUtil.copyList(src.getCopyDefinitions());
  }

  public ActivityType getType() {
    return ActivityType.ASSIGN;
  }

  public boolean isValidate() {
    return this.validate;
  }

  public List<CopyDefinition> getCopyDefinitions() {
    return this.copyDefinitions;
  }

}
