/**
 * Copyright (C) 2011 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import org.ow2.orchestra.facade.def.ExtensionDefinition;

/**
 * @author manhtoan
 */
public class ExtensionDefinitionImpl implements ExtensionDefinition {
  private static final long serialVersionUID = 1L;
  /**
   * Namespace attribute of the extension element.
   */
  protected String namespace;
  /**
   * mustUnderstand attribute of the extension element.
   */
  protected boolean mustUnderstand;
  /**
   * supported if the extension element is actually supported by Orchestra
   */
  protected boolean supported;

  protected ExtensionDefinitionImpl() {
  }

  public ExtensionDefinitionImpl(String namespace, boolean mustUnderstand, boolean isSupported) {
    this.namespace = namespace;
    this.mustUnderstand = mustUnderstand;
    this.supported = isSupported;
  }

  private ExtensionDefinitionImpl(ExtensionDefinitionImpl extensionDefinitionImpl) {
    this(extensionDefinitionImpl.getNamespace(), extensionDefinitionImpl.isMustUnderstand(), extensionDefinitionImpl.isSupported());
  }

  public boolean isMustUnderstand() {
    return mustUnderstand;
  }

  public String getNamespace() {
    return namespace;
  }

  public boolean isSupported() {
    return supported;
  }

  public ExtensionDefinition copy() {
    return new ExtensionDefinitionImpl(this);
  }


}
