/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.CorrelationDefinition;
import org.ow2.orchestra.facade.def.FromPartDefinition;
import org.ow2.orchestra.facade.def.ReceiveActivityDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;

/**
 * @author Alfonso Fuca
 */
@XmlRootElement(name = "receive")
public class ReceiveActivityDefinitionImpl extends BpelActivityDefinitionImpl implements ReceiveActivityDefinition {

  private static final long serialVersionUID = 6823731155200345051L;

  private boolean createInstance;
  private String variable;
  private QName portType;
  private String partnerLink;
  private String operation;
  private String messageExchange;

  private List<CorrelationDefinition> correlationDefinitionList;
  private List<FromPartDefinition> fromPartDefinitionList;

  private ReceiveActivityDefinitionImpl() {
  }

  public ReceiveActivityDefinitionImpl(final ReceiveActivityDefinition src) {
    super(src);
    this.variable = src.getVariable();
    this.createInstance = src.isCreateInstance();
    this.portType = src.getPortType();
    this.partnerLink = src.getPartnerLink();
    this.operation = src.getOperation();
    this.messageExchange = src.getMessageExchange();
    this.correlationDefinitionList = new ArrayList<CorrelationDefinition>();
    this.correlationDefinitionList = CopyUtil.copyList(src.getCorrelationDefinitions());
    this.fromPartDefinitionList = new ArrayList<FromPartDefinition>();
    this.fromPartDefinitionList = CopyUtil.copyList(src.getFromPartDefinitions());
  }

  public ActivityType getType() {
    return ActivityType.RECEIVE;
  }

  public String getMessageExchange() {
    return this.messageExchange;
  }

  public String getOperation() {
    return this.operation;
  }

  public String getPartnerLink() {
    return this.partnerLink;
  }

  public QName getPortType() {
    return this.portType;
  }

  public String getVariable() {
    return this.variable;
  }

  public boolean isCreateInstance() {
    return this.createInstance;
  }

  public List<CorrelationDefinition> getCorrelationDefinitions() {
    return this.correlationDefinitionList;
  }

  public List<FromPartDefinition> getFromPartDefinitions() {
    return this.fromPartDefinitionList;
  }

}
