/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import javax.xml.bind.annotation.XmlRootElement;
import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.ForDefinition;
import org.ow2.orchestra.facade.def.UntilDefinition;
import org.ow2.orchestra.facade.def.WaitActivityDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;

/**
 * @author Alfonso Fuca
 */
@XmlRootElement(name = "wait")
public class WaitActivityDefinitionImpl extends BpelActivityDefinitionImpl implements WaitActivityDefinition {

  private static final long serialVersionUID = -4730855566596247617L;

  private ForDefinition forDefinition;

  private UntilDefinition untilDefinition;

  private WaitActivityDefinitionImpl() {
  }

  public WaitActivityDefinitionImpl(final WaitActivityDefinition src) {
    super(src);
    this.forDefinition = CopyUtil.copy(src.getForDefinition());
    this.untilDefinition = CopyUtil.copy(src.getUntilDefinition());
  }

  public ActivityType getType() {
    return ActivityType.WAIT;
  }

  public ForDefinition getForDefinition() {
    return this.forDefinition;
  }

  public UntilDefinition getUntilDefinition() {
    return this.untilDefinition;
  }
}
