/**
 * Copyright (C) 2007  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.runtime.impl;

import org.ow2.orchestra.facade.runtime.Message;
import org.ow2.orchestra.util.JAXBUtils;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Models a WSDL message type variable.
 *
 * @author Goulven Le Jeune, Charles Souillard, Candy Chlad, Stanislas Giraudet
 *         De Boudemange, Guillaume Porcher
 */
@XmlRootElement(name = "message")
public class MessageImpl implements Message, Serializable {

  private static final long serialVersionUID = -1923279216159214497L;

  @XmlElement
  @XmlJavaTypeAdapter(JAXBUtils.JAXBDOMDocumentAdapter.class)
  protected Document parts;

  /**
   *
   */
  public MessageImpl() {
    super();
  }


  /**
   * @param duplicateParts
   */
  public MessageImpl(final Document duplicateParts) {
    this.parts = duplicateParts;
  }


  public Element getPartElement(final String partName) {
    if (partName != null) {
      return XmlUtil.element(this.parts.getDocumentElement(), partName);
    }
    return XmlUtil.element(this.parts.getDocumentElement());
  }

  public Element getPartValue(final String partName) {
    final Element partElt = this.getPartElement(partName);
    return XmlUtil.element(partElt);
  }

  /**
   * Export to log message.
   *
   * @return The duplicate of Xml object
   */
  public MessageImpl copy() {
    if (this.parts == null) {
      return null;
    }
    final Document duplicateParts = XmlUtil.copyDocument(this.parts);
    return new MessageImpl(duplicateParts);
  }

  public Map<String, Element> getParts() {
    final List<Element> partElements = XmlUtil.elements(this.parts.getDocumentElement());
    final Map<String, Element> res = new HashMap<String, Element>();
    if (partElements != null) {
      for (final Element elt : partElements) {
        res.put(elt.getTagName(), XmlUtil.element(elt));
      }
    }
    return res;
  }

  public boolean hasPart(final String partName) {
    return this.getPartElement(partName) != null;
  }

  private void writeObject(final java.io.ObjectOutputStream out) throws IOException {
    out.writeObject(XmlUtil.toString(this.parts));
  }
  private void readObject(final java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
    this.parts = XmlUtil.getDocumentFromString((String) in.readObject());
  }

  /**
   * Return a string representation of the message.
   *
   * @return a String representation of the message
   */
  @Override
  public String toString() {
    return XmlUtil.toString(this.parts);
  }
}
