/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime.impl;

import org.ow2.orchestra.facade.runtime.PartnerLinkUpdate;
import org.ow2.orchestra.facade.runtime.PartnerLinkUpdateType;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Date;

/**
 *
 * @author Gael Lalire
 */
@XmlRootElement(name = "partnerLinkUpdate")
public class PartnerLinkUpdateImpl implements PartnerLinkUpdate {

  private static final long serialVersionUID = -2069580133901045271L;
  @XmlElement
  private ActivityInstanceUUID activityUUID;
  @XmlElement
  private Date date;
  @XmlElement
  private String name;
  @XmlElement
  private PartnerLinkUpdateType partnerLinkUpdateType;
  @XmlElement
  private String partnerLinkReference;

  protected PartnerLinkUpdateImpl() {}

  public PartnerLinkUpdateImpl(final PartnerLinkUpdate record) {
    this.activityUUID = record.getActivityUUID();
    this.date = new Date(record.getDate().getTime());
    this.name = record.getName();
    this.partnerLinkReference = XmlUtil.toString(record.getPartnerLinkReference());
    this.partnerLinkUpdateType = record.getPartnerLinkUpdateType();
  }

  public ActivityInstanceUUID getActivityUUID() {
    return this.activityUUID;
  }

  public Date getDate() {
    return new Date(this.date.getTime());
  }

  public String getName() {
    return this.name;
  }

  public Element getPartnerLinkReference() {
    return XmlUtil.getDocumentFromString(this.partnerLinkReference).getDocumentElement();
  }

  public PartnerLinkUpdateType getPartnerLinkUpdateType() {
    return this.partnerLinkUpdateType;
  }

  public PartnerLinkUpdate copy() {
    return new PartnerLinkUpdateImpl(this);
  }

}
