/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.data.runtime;

import org.ow2.orchestra.facade.data.AbstractData;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;

/**
 *
 * @author Gael Lalire
 */
public class ForeachInitializedData extends AbstractData {

  private static final long serialVersionUID = 8552680508951133268L;

  private final ActivityInstanceUUID activityInstanceUUID;

  private final int startValue;

  private final int stopValue;

  private final Integer completionConditionValue;

  public ForeachInitializedData(final ActivityInstanceUUID activityInstanceUUID, final int startValue, final int stopValue,
    final Integer completionConditionValue) {
    this.activityInstanceUUID = activityInstanceUUID;
    this.startValue = startValue;
    this.stopValue = stopValue;
    this.completionConditionValue = completionConditionValue;
  }

  /**
   * @return the activityInstanceUUID
   */
  public ActivityInstanceUUID getActivityInstanceUUID() {
    return this.activityInstanceUUID;
  }

  /**
   * @return the startValue
   */
  public int getStartValue() {
    return this.startValue;
  }

  /**
   * @return the stopValue
   */
  public int getStopValue() {
    return this.stopValue;
  }

  /**
   * @return the completionConditionValue
   */
  public Integer getCompletionConditionValue() {
    return this.completionConditionValue;
  }

}
