/**
 * Copyright (C) 2006-2009  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.def;

import java.util.List;

/**
 * @author Gael Lalire
 */
public interface BpelActivityDefinition extends ActivityDefinition {

  /**
   *
   * @return the value of the suppresionJoinFailure attribute
   */
  boolean isSuppressJoinFailure();

  /**
   *
   * @return expression language of targets join condition
   */
  String getTargetsJoinConditionExpressionLanguage();

  /**
   * If this string is null there is no join condition
   *
   * @return
   */
  String getTargetsJoinConditionBooleanExpression();

  /**
   *
   * @return the list of targets
   */
  List< ? extends Target> getTargetList();

  /**
   *
   * @return the list of sources
   */
  List< ? extends Source> getSourceList();

}
