/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.def.CatchDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;

/**
 * @author S. Ali Tokmen
 */
@XmlRootElement(name = "catch")
public class CatchDefinitionImpl extends BaseCatchDefinitionImpl<CatchDefinition> implements CatchDefinition {

  private static final long serialVersionUID = -5625955644411979957L;

  private CatchDefinitionImpl() {}

  public CatchDefinitionImpl(final CatchDefinition catchDefinition) {
    super(catchDefinition);
    this.faultElement = catchDefinition.getFaultElement();
    this.faultMessageType = catchDefinition.getFaultMessageType();
    this.faultName = catchDefinition.getFaultName();
    this.faultVariable = catchDefinition.getFaultVariable();
  }

  protected QName faultElement;

  protected QName faultMessageType;

  protected QName faultName;

  protected String faultVariable;

  public QName getFaultElement() {
    return this.faultElement;
  }

  public QName getFaultMessageType() {
    return this.faultMessageType;
  }

  public QName getFaultName() {
    return this.faultName;
  }

  public String getFaultVariable() {
    return this.faultVariable;
  }

  public CatchDefinition copy() {
    return new CatchDefinitionImpl(this);
  }

  public ActivityType getType() {
    return ActivityType.CATCH_HANDLER;
  }

}
