/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import javax.xml.bind.annotation.XmlRootElement;
import org.ow2.orchestra.facade.def.CompensateScopeActivityDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;

/**
 * @author S. Ali Tokmen
 */
@XmlRootElement(name = "compensateScope")
public class CompensateScopeActivityDefinitionImpl extends BpelActivityDefinitionImpl
        implements CompensateScopeActivityDefinition {

  private static final long serialVersionUID = -4594307198956506957L;

  private String target;

  protected CompensateScopeActivityDefinitionImpl() {
  }

  public CompensateScopeActivityDefinitionImpl(final CompensateScopeActivityDefinition activityDefinition) {
    super(activityDefinition);
    this.target = activityDefinition.getTarget();
  }

  public String getTarget() {
    return this.target;
  }

  public ActivityType getType() {
    return ActivityType.COMPENSATE_SCOPE;
  }


}
