/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import javax.xml.namespace.QName;

import org.ow2.orchestra.facade.def.FromToDefinition;
import org.ow2.orchestra.facade.def.Variant;

public class FromToDefinitionImpl implements FromToDefinition {

  private static final long serialVersionUID = 6048928207663625115L;

  private Variant variant;

  private String variable;

  private QName property;

  private String partnerLink;

  private String part;

  private String expressionLanguage;

  private String endpointReference;

  private String expression;

  private String queryLanguage;

  private String query;

  protected FromToDefinitionImpl() {
  }

  public FromToDefinitionImpl(final FromToDefinition fromToDefinition) {
    this.variant = fromToDefinition.getVariant();
    this.variable = fromToDefinition.getVariable();
    this.property = fromToDefinition.getProperty();
    this.partnerLink = fromToDefinition.getPartnerLink();
    this.part = fromToDefinition.getPart();
    this.expressionLanguage = fromToDefinition.getExpressionLanguage();
    this.expression = fromToDefinition.getExpression();
    this.endpointReference = fromToDefinition.getEndpointReference();
    this.query = fromToDefinition.getQuery();
    this.queryLanguage = fromToDefinition.getQueryLanguage();
  }

  public String getEndpointReference() {
    return endpointReference;
  }

  /*public Expression getExpression() {
    return expression;
  }*/

  public String getExpressionLanguage() {
    return expressionLanguage;
  }

  public String getPart() {
    return part;
  }

  public String getPartnerLink() {
    return partnerLink;
  }

  public QName getProperty() {
    return property;
  }

  /*public PropertyQuery getPropertyQuery() {
    return propertyQuery;
  }*/

  public String getVariable() {
    return variable;
  }

  /*public VariableQuery getVariableQuery() {
    return variableQuery;
  }*/

  public Variant getVariant() {
    return variant;
  }

  public String getExpression() {
    return expression;
  }

  public String getQuery() {
    return query;
  }

  public String getQueryLanguage() {
    return queryLanguage;
  }
}
