/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.ElseDefinition;
import org.ow2.orchestra.facade.def.ElseIfDefinition;
import org.ow2.orchestra.facade.def.IfActivityDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;

@XmlRootElement(name = "if")
public class IfActivityDefinitionImpl extends BpelActivityWithSingleChildDefinitionImpl implements IfActivityDefinition {

  private static final long serialVersionUID = 3466900563857594409L;

  private String expression;

  private String expressionLanguage;

  private List<ElseIfDefinition> elseIfDefinitionList;

  private ElseDefinition elseDefinition;

  private IfActivityDefinitionImpl() {
  }

  public IfActivityDefinitionImpl(final IfActivityDefinition record) {
    super(record);
    this.expression = record.getExpression();
    this.expressionLanguage = record.getExpressionLanguage();
    this.elseDefinition = CopyUtil.copy(record.getElseDefinition());
    this.elseIfDefinitionList = CopyUtil.copyList(record.getElseIfDefinitionList());
  }

  public ActivityType getType() {
    return ActivityType.IF;
  }

  public String getExpression() {
    return this.expression;
  }

  public String getExpressionLanguage() {
    return this.expressionLanguage;
  }

  public List<ElseIfDefinition> getElseIfDefinitionList() {
    return this.elseIfDefinitionList;
  }

  public ElseDefinition getElseDefinition() {
    return this.elseDefinition;
  }

}
