/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.CorrelationDefinition;
import org.ow2.orchestra.facade.def.FromPartDefinition;
import org.ow2.orchestra.facade.def.InvokeActivityDefinition;
import org.ow2.orchestra.facade.def.ToPartDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;

/**
 * @author Gael Lalire
 */
@XmlRootElement(name = "invoke")
public class InvokeDefinitionImpl extends BpelActivityDefinitionImpl implements InvokeActivityDefinition {

  private static final long serialVersionUID = -6313088303704824547L;

  private List<CorrelationDefinition> correlationDefinitions;

  private List<FromPartDefinition> fromPartDefinitions;

  private List<ToPartDefinition> toPartDefinitions;

  private String partnerLink;

  private String inputVariable;

  private String outputVariable;

  private String operation;

  private QName portType;

  private InvokeDefinitionImpl() {
  }

  public InvokeDefinitionImpl(final InvokeActivityDefinition invokeDefinition) {
    super(invokeDefinition);
    this.correlationDefinitions = CopyUtil.copyList(invokeDefinition.getCorrelationDefinitions());
    this.fromPartDefinitions = CopyUtil.copyList(invokeDefinition.getFromPartDefinitions());
    this.toPartDefinitions = CopyUtil.copyList(invokeDefinition.getToPartDefinitions());
    this.partnerLink = invokeDefinition.getPartnerLink();
    this.inputVariable = invokeDefinition.getInputVariable();
    this.outputVariable = invokeDefinition.getOutputVariable();
    this.operation = invokeDefinition.getOperation();
    this.portType = invokeDefinition.getPortType();
  }

  public InvokeActivityDefinition copy() {
    return new InvokeDefinitionImpl(this);
  }

  /**
   * @return the correlationDefinitions
   */
  public List<CorrelationDefinition> getCorrelationDefinitions() {
    return this.correlationDefinitions;
  }

  /**
   * @return the fromPartDefinitions
   */
  public List<FromPartDefinition> getFromPartDefinitions() {
    return this.fromPartDefinitions;
  }

  /**
   * @return the inputVariable
   */
  public String getInputVariable() {
    return this.inputVariable;
  }

  /**
   * @return the outputVariable
   */
  public String getOutputVariable() {
    return this.outputVariable;
  }

  /**
   * @return the operation
   */
  public String getOperation() {
    return this.operation;
  }

  /**
   * @return the toPartDefinitions
   */
  public List<ToPartDefinition> getToPartDefinitions() {
    return this.toPartDefinitions;
  }

  /**
   * @return the portType
   */
  public QName getPortType() {
    return this.portType;
  }

  public ActivityType getType() {
    return ActivityType.INVOKE;
  }


  /**
   * @return the partnerLink
   */
  public String getPartnerLink() {
    return this.partnerLink;
  }

}
