/**
 * Copyright (C) 2010  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.def.impl;

import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.def.ProcessStateUpdate;


/**
 * @author Guillaume Porcher
 */
@XmlRootElement(name = "ProcessStateUpdate")
public class ProcessStateUpdateImpl implements ProcessStateUpdate {

  private static final long serialVersionUID = 1485764789708354291L;

  @XmlElement
  protected Date date;
  @XmlElement
  protected ProcessState state;

  protected ProcessStateUpdateImpl() {
  }

  public ProcessStateUpdateImpl(final Date date, final ProcessState state) {
    this.date = date;
    this.state = state;
  }

  public ProcessStateUpdateImpl(final ProcessStateUpdate src) {
    this.date = src.getDate();
    this.state = src.getState();
  }

  public ProcessStateUpdate copy() {
    return new ProcessStateUpdateImpl(this);
  }

  public Date getDate() {
    return this.date;
  }

  public ProcessState getState() {
    return this.state;
  }

}
