/**
 * Copyright (C) 2007-2009  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.runtime.impl;

import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.util.Misc;

import javax.xml.bind.annotation.XmlElement;

/**
 * @author Gael Lalire, S. Ali Tokmen
 */
public abstract class ActivityInstanceImpl extends RuntimeRecordImpl implements ActivityInstance {

  private static final long serialVersionUID = -8839590974299983697L;

  @XmlElement
  protected ActivityInstanceUUID uuid;
  @XmlElement
  protected ActivityDefinitionUUID definitionUUID;
// TODO: serialize this element  @XmlElement
  protected BpelFaultException lastException;

  protected ActivityInstanceImpl() {}
  public ActivityInstanceImpl(final ActivityInstance record) {
    super(record);
    this.uuid = record.getUUID();
    this.definitionUUID = record.getDefinitionUUID();
    this.lastException = record.getLastException() != null ? record.getLastException().copy() : null;
  }

  @Override
  public String toString() {
    final String st = this.getClass().getName()
      + "[uuid: " + this.getUUID()
      + ", processDefinitionUUID: " + this.getProcessDefinitionUUID()
      + ", processUUID: " + this.getProcessInstanceUUID()
      + ", startedDate: " + this.getStartedDate()
      + ", endedDate: " + this.getEndedDate()
      + "]" + Misc.LINE_SEPARATOR;
    return st;
  }

  public ActivityInstanceUUID getUUID() {
    return this.uuid;
  }

  public ActivityDefinitionUUID getDefinitionUUID() {
    return this.definitionUUID;
  }

  public BpelFaultException getLastException() {
    return this.lastException;
  }

  @Override
  public final int hashCode() {
    return this.uuid.hashCode() + super.hashCode();
  }

  @Override
  public final boolean equals(final Object obj) {
    if (obj == null) {
      return false;
    }
    if (!(obj.getClass().equals(this.getClass()))) {
      return false;
    }
    if (!super.equals(obj)) {
      return false;
    }
    if (!this.uuid.equals(((ActivityInstanceImpl) obj).getUUID())) {
      return false;
    }
    return true;
  }

}
