/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime.impl;

import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.PickActivityInstance;
import org.ow2.orchestra.facade.runtime.WaitingActivity;

import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;

/**
 *
 * @author Gael Lalire
 */
@XmlRootElement(name = "pickInstance")
public class PickActivityInstanceImpl extends ActivityWithSingleChildInstanceImpl implements PickActivityInstance {

  private static final long serialVersionUID = -8696405119148398704L;
  @XmlElementWrapper
  @XmlAnyElement(lax = true)
  private List<WaitingActivity> waitingActivityList;

  protected PickActivityInstanceImpl() {}

  public PickActivityInstanceImpl(final PickActivityInstance record) {
    super(record);
    this.waitingActivityList = CopyUtil.copyList(record.getWaitingActivityList());
  }

  public ActivityType getType() {
    return ActivityType.WAIT;
  }

  public List<WaitingActivity> getWaitingActivityList() {
    return this.waitingActivityList;
  }

}
