/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime.impl;

import java.util.Date;

import org.ow2.orchestra.facade.runtime.TransitionConditionUpdate;

public class TransitionConditionUpdateImpl implements TransitionConditionUpdate {

  private static final long serialVersionUID = 7688584775144614209L;

  private final boolean status;

  private final String name;

  private final Date date;

  public TransitionConditionUpdateImpl(final TransitionConditionUpdate transitionConditionUpdate) {
    this.status = transitionConditionUpdate.getStatus();
    this.name = transitionConditionUpdate.getName();
    this.date = new Date(transitionConditionUpdate.getDate().getTime());
  }

  public boolean getStatus() {
    return this.status;
  }

  public String getName() {
    return this.name;
  }

  public Date getDate() {
    return new Date(this.date.getTime());
  }

  public TransitionConditionUpdate copy() {
    return new TransitionConditionUpdateImpl(this);
  }
}
