/*******************************************************************************
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 *******************************************************************************/
package org.ow2.orchestra.facade.rest;

import org.ow2.orchestra.facade.def.ActivityDefinition;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.def.ProcessState;
import org.ow2.orchestra.facade.exception.ActivityNotFoundException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

/**
 * @author Guillaume Porcher
 */
@Path("/queryDefinition/")
public interface JaxRSQueryDefinitionAPI {
  // QUERIER DEFINITION API
  @GET
  @Path("/process")
  CollectionWrapper<ProcessDefinition> findProcessDefinitions(
          @QueryParam("namespace") String processNamespace,
          @QueryParam("name") String processName,
          @QueryParam("state") ProcessState state);

  @GET
  @Path("/process/{processUUID}")
  InterfaceWrapper<ProcessDefinition> getProcessDefinition(@PathParam("processUUID") ProcessDefinitionUUID processUUID) throws
          ProcessNotFoundException;

  @GET
  @Path("/activity/{activityUUID}")
  InterfaceWrapper<ActivityDefinition> getActivityDefinition(@PathParam("activityUUID") ActivityDefinitionUUID activityDefUUID)
          throws ActivityNotFoundException;

  @GET
  @Path("/process/{processUUID}/activities")
  CollectionWrapper<ActivityDefinition> findActivityDefinitions(@PathParam("processUUID") ProcessDefinitionUUID processUUID)
          throws ProcessNotFoundException;

  @GET
  @Path("/process/{processUUID}/resource/{resourceName}")
  ByteArrayWrapper getProcessResource(@PathParam("processUUID") ProcessDefinitionUUID processUUID, @PathParam("resourceName") String resourceName)
          throws ProcessNotFoundException;

}
