/**
 * Copyright (C) 2008-2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.BpelActivityDefinition;
import org.ow2.orchestra.facade.def.Source;
import org.ow2.orchestra.facade.def.Target;

import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import java.util.List;

/**
 * @author Gael Lalire
 */
public abstract class BpelActivityDefinitionImpl extends ActivityDefinitionImpl implements BpelActivityDefinition {

  private static final long serialVersionUID = -8662979282414910900L;

  @XmlElement
  protected boolean suppressJoinFailure;
  @XmlElementWrapper
  @XmlAnyElement(lax = true)
  protected List<Source> sourceList;
  @XmlElementWrapper
  @XmlAnyElement(lax = true)
  protected List<Target> targetList;
  @XmlElement
  protected String targetsJoinConditionExpressionLanguage;
  @XmlElement
  protected String targetsJoinConditionBooleanExpression;

  protected BpelActivityDefinitionImpl() {
  }

  public BpelActivityDefinitionImpl(final BpelActivityDefinition src) {
    super(src);
    suppressJoinFailure = src.isSuppressJoinFailure();
    sourceList = CopyUtil.copyList(src.getSourceList());
    targetList = CopyUtil.copyList(src.getTargetList());
    targetsJoinConditionExpressionLanguage = src.getTargetsJoinConditionExpressionLanguage();
    targetsJoinConditionBooleanExpression = src.getTargetsJoinConditionBooleanExpression();
  }

  /**
   * @return the suppressJoinFailure
   */
  public boolean isSuppressJoinFailure() {
    return suppressJoinFailure;
  }

  public List<Source> getSourceList() {
    return sourceList;
  }

  public List<Target> getTargetList() {
    return targetList;
  }

  public String getTargetsJoinConditionBooleanExpression() {
    return targetsJoinConditionBooleanExpression;
  }

  public String getTargetsJoinConditionExpressionLanguage() {
    return targetsJoinConditionExpressionLanguage;
  }

}
