/*******************************************************************************
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 *******************************************************************************/
package org.ow2.orchestra.facade.rest;

import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

/**
 * @author Guillaume Porcher
 */
@Path("/management/")
public interface JaxRSManagementAPI {
  @PUT
  @Path("/process?type=deployment")
  InterfaceWrapper<ProcessDefinition> deploy(Deployment bpelDeployment);

  @PUT
  @Path("/process/{processUUID}/webServices")
  void deployWebServices(@PathParam("processUUID") ProcessDefinitionUUID processDefinitionUUID);

  @DELETE
  @Path("/process/{processUUID}/webServices")
  void undeployWebServices(@PathParam("processUUID") ProcessDefinitionUUID processDefinitionUUID);

  @POST
  @Path("/process/undeploy")
  boolean undeploy(@QueryParam("namespace") String processNamespace,
                   @QueryParam("name") String processName);

  @POST
  @Path("/process/{processUUID}/undeploy")
  boolean undeploy(@PathParam("processUUID") ProcessDefinitionUUID pduuid);

  @POST
  @Path("/process/{processUUID}/remove")
  boolean remove(@PathParam("processUUID") ProcessDefinitionUUID processDefinitionUUID);

  @POST
  @Path("/process/{processUUID}/activate")
  boolean activate(@PathParam("processUUID") ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException;

  @POST
  @Path("/process/{processUUID}/retire")
  boolean retire(@PathParam("processUUID") ProcessDefinitionUUID processDefinitionUUID) throws ProcessNotFoundException;

  @POST
  @Path("/process/{processUUID}/refresh")
  void refreshProcess(@PathParam("processUUID") ProcessDefinitionUUID processDefinitionUUID);

  @PUT
  @Path("/process?type=bar")
  InterfaceWrapper<ProcessDefinition> deployBar(ByteArrayWrapper barFile);

  @POST
  @Path("/init")
  void initialize();

  @POST
  @Path("/supportedExtensions")
  boolean isExtensionSupported(@QueryParam("namespace") String namespace);
}
