/*******************************************************************************
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 *******************************************************************************/
package org.ow2.orchestra.facade.rest;

import org.ow2.orchestra.facade.criteria.Criteria;
import org.ow2.orchestra.facade.criteria.PagedResult;
import org.ow2.orchestra.facade.exception.ActivityInstanceNotFoundException;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.ProcessNotFoundException;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

/**
 * @author Guillaume Porcher
 */
@Path("/queryRuntime/")
public interface JaxRSQueryRuntimeAPI {
  @GET
  @Path("/instance/{instanceUUID}/activities")
  CollectionWrapper<ActivityInstance> findActivityInstances(
          @PathParam("instanceUUID") ProcessInstanceUUID instanceUUID,
          @QueryParam("state") ActivityState activityState)
          throws InstanceNotFoundException;

  @GET
  @Path("/activity/{activityUUID}")
  InterfaceWrapper<ActivityInstance> getActivityInstance(@PathParam("activityUUID") ActivityInstanceUUID activityInstanceUUID)
          throws ActivityInstanceNotFoundException;

  @GET
  @Path("/instance")
  CollectionWrapper<ProcessInstance> findProcessInstances(
          @QueryParam("processUUID") ProcessDefinitionUUID processDefinitionUUID,
          @QueryParam("state") ActivityState processInstanceState) throws ProcessNotFoundException;


  @GET
  @Path("/instance/{instanceUUID}")
  InterfaceWrapper<ProcessInstance> getProcessInstance(@PathParam("instanceUUID") ProcessInstanceUUID processInstanceUUID)
          throws InstanceNotFoundException;
  @POST
  @Path("/instance/page")
  PagedResult<ProcessInstance> findProcessInstancesPage(Criteria<ProcessInstance> criteria);
}
