/*******************************************************************************
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 *******************************************************************************/
package org.ow2.orchestra.facade.rest;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author Guillaume Porcher
 */
@XmlRootElement(name = "simpleCollectionWrapper")
public class SimpleCollectionWrapper<T> {
  @XmlElement
  protected Collection<T> content;

  public SimpleCollectionWrapper() {
  }

  public static <T> SimpleCollectionWrapper<T> make(Collection<T> source) {
    SimpleCollectionWrapper<T> wrapper = new SimpleCollectionWrapper<T>();
    wrapper.content = source;
    return wrapper;
  }

  public Collection<T> getContent() {
    return content;
  }

  public List<T> getContentAsList() {
    if (content == null) {
      return null;
    }
    return new ArrayList<T>(content);
  }

  public Set<T> getContentAsSet() {
    if (content == null) {
      return null;
    }
    return new HashSet<T>(content);
  }
}
