/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime.impl;

import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.ReceiveActivityInstance;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * @author Alfonso Fuca
 */
@XmlRootElement(name = "receiveInstance")
public class ReceiveActivityInstanceImpl extends ActivityInstanceImpl implements ReceiveActivityInstance {

  private static final long serialVersionUID = -3693697309465044685L;
  @XmlElement
  protected String operation;
  @XmlElement
  protected String variable;
  @XmlElement
  protected String messageExchange;

  protected ReceiveActivityInstanceImpl() {}

  public ReceiveActivityInstanceImpl(final ReceiveActivityInstance record) {
    super(record);
    this.operation = record.getOperation();
    this.variable = record.getVariable();
    this.messageExchange = record.getMessageExchange();
  }

  public ActivityType getType() {
    return ActivityType.RECEIVE;
  }

  @Override
  public String toString() {
    String st = this.getClass().getName() + "[uuid: " + this.getUUID()
            + ", processDefinitionUUID: " + this.getProcessDefinitionUUID()
            + ", processUUID: " + this.getProcessInstanceUUID()
            + ", startedDate: " + this.getStartedDate() + ", endedDate: " + this.getEndedDate()
            + ", activityType: " + this.getType() + ", operation: " + this.getOperation() + ", variable: " + this.getVariable()
            + ", messageExchange: " + this.getMessageExchange();
    st += "]\n";
    return st;
  }

  public String getMessageExchange() {
    return this.messageExchange;
  }

  public String getOperation() {
    return this.operation;
  }

  public String getVariable() {
    return this.variable;
  }

}
