/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.data.def;

import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;

/**
 *
 * @author Gael Lalire
 */
public class ReplyActivityDefinitionData extends ActivityDefinitionData {

  private static final long serialVersionUID = 712668192824383622L;

  private final String operation;

  private final String variable;

  private final String messageExchange;

  public ReplyActivityDefinitionData(final ProcessDefinitionData processDefinitionData, final ActivityDefinitionUUID uuid,
                                     final String name, final String operation, final String variable,
                                     final String messageExchange) {
    super(processDefinitionData, uuid, ActivityType.REPLY, name);
    this.operation = operation;
    this.variable = variable;
    this.messageExchange = messageExchange;
  }

  public String getOperation() {
    return this.operation;
  }

  public String getVariable() {
    return this.variable;
  }

  public String getMessageExchange() {
    return this.messageExchange;
  }

}
