/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.data.runtime;

import java.io.IOException;

import org.ow2.orchestra.facade.runtime.PartnerLinkUpdateType;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.util.XmlUtil;
import org.w3c.dom.Element;

/**
 *
 * @author Gael Lalire
 */
public class PartnerLinkUpdateData extends ScopeUpdateData {

  private static final long serialVersionUID = -4705971360650536218L;

  protected String name;

  private PartnerLinkUpdateType partnerLinkUpdateType;

  private Element partnerLinkReference;

  public PartnerLinkUpdateData(final ActivityInstanceUUID scopeActivityUUID, final ActivityInstanceData activityData,
    final String name, final PartnerLinkUpdateType partnerLinkUpdateType, final Element partnerLinkReference) {
    super(scopeActivityUUID, activityData);
    this.name = name;
    this.partnerLinkUpdateType = partnerLinkUpdateType;
    this.partnerLinkReference = partnerLinkReference;
  }

  /**
   * @return the name
   */
  public String getName() {
    return this.name;
  }

  /**
   * @return the partnerLinkUpdateType
   */
  public PartnerLinkUpdateType getPartnerLinkUpdateType() {
    return this.partnerLinkUpdateType;
  }

  /**
   * @return the partnerLinkReference
   */
  public Element getPartnerLinkReference() {
    return this.partnerLinkReference;
  }

  private void writeObject(final java.io.ObjectOutputStream out) throws IOException {
    out.writeObject(this.name);
    out.writeObject(this.partnerLinkUpdateType);
    out.writeObject(XmlUtil.toString(this.partnerLinkReference));
  }

  private void readObject(final java.io.ObjectInputStream in) throws IOException, ClassNotFoundException {
    this.name = (String) in.readObject();
    this.partnerLinkUpdateType = (PartnerLinkUpdateType) in.readObject();
    this.partnerLinkReference = XmlUtil.getDocumentFromString((String) in.readObject()).getDocumentElement();
  }
}
