package org.ow2.orchestra.facade.data.runtime;

import org.ow2.orchestra.facade.data.AbstractData;
import org.ow2.orchestra.facade.runtime.Message;

import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import java.util.Date;

@XmlRootElement(name = "pendingMessage")
public class PendingMessageData extends AbstractData {

  @XmlElement
  protected long messageId;

  @XmlAnyElement(lax = true)
  protected Message message;

  @XmlElement
  protected QName processQName;
  @XmlElement
  protected QName portTypeQName;
  @XmlElement
  protected String operationName;
  @XmlElement
  protected boolean isOneWay;
  @XmlElement
  protected Date addedDate;

  protected PendingMessageData() {}

  public PendingMessageData(final long messageId, final Message message, final QName processQName, final QName portTypeQName, final String operationName, final boolean isOneWay, final Date addedDate) {
    super();
    this.messageId = messageId;
    this.message = message;
    this.processQName = processQName;
    this.portTypeQName = portTypeQName;
    this.operationName = operationName;
    this.isOneWay = isOneWay;
    this.addedDate = addedDate;
  }


  public long getMessageId() {
    return this.messageId;
  }


  public Message getMessage() {
    return this.message;
  }


  public QName getProcessQName() {
    return this.processQName;
  }


  public QName getPortTypeQName() {
    return this.portTypeQName;
  }


  public String getOperationName() {
    return this.operationName;
  }


  public boolean isOneWay() {
    return this.isOneWay;
  }


  public Date getAddedDate() {
    return this.addedDate;
  }

}
