/**
 * Copyright (C) 2006  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/
package org.ow2.orchestra.facade.def;

import org.ow2.orchestra.facade.Record;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;

/**
 * Parent class for all definition record.
 * @author Gael Lalire
 */
public interface DefinitionRecord extends Record {

  /**
   * @return the name of process or activity (NCName), this
   * name can be null if the record is an activity.
   */
  String getName();

  /**
   * All orchestra definition record are linked to a process definition
   * @return the uuid of process definition
   */
  ProcessDefinitionUUID getProcessDefinitionUUID();

}


