/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.CorrelationDefinition;
import org.ow2.orchestra.facade.def.ReplyActivityDefinition;
import org.ow2.orchestra.facade.def.ToPartDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;

@XmlRootElement(name = "reply")
public class ReplyActivityDefinitionImpl extends BpelActivityDefinitionImpl implements ReplyActivityDefinition {

  private static final long serialVersionUID = 953677591273172009L;

  private QName faultName;
  private List<ToPartDefinition> toPartDefinitionList;
  private List<CorrelationDefinition> correlationDefinitionList;
  private String variable;
  private QName portType;
  private String partnerLink;
  private String operation;
  private String messageExchange;

  private ReplyActivityDefinitionImpl() {
  }

  public ReplyActivityDefinitionImpl(final ReplyActivityDefinition replyActivityDefinition) {
    super(replyActivityDefinition);
    this.variable = replyActivityDefinition.getVariable();
    this.portType = replyActivityDefinition.getPortType();
    this.partnerLink = replyActivityDefinition.getPartnerLink();
    this.operation = replyActivityDefinition.getOperation();
    this.messageExchange = replyActivityDefinition.getMessageExchange();
    this.faultName = replyActivityDefinition.getFaultName();
    this.correlationDefinitionList = new ArrayList<CorrelationDefinition>();
    this.correlationDefinitionList = CopyUtil.copyList(replyActivityDefinition.getCorrelationDefinitions());
    this.toPartDefinitionList = new ArrayList<ToPartDefinition>();
    this.toPartDefinitionList = CopyUtil.copyList(replyActivityDefinition.getToPartDefinitions());
  }

  public ActivityType getType() {
    return ActivityType.REPLY;
  }

  public String getMessageExchange() {
    return this.messageExchange;
  }

  public String getOperation() {
    return this.operation;
  }

  public String getPartnerLink() {
    return this.partnerLink;
  }

  public QName getPortType() {
    return this.portType;
  }

  public String getVariable() {
    return this.variable;
  }

  public List<CorrelationDefinition> getCorrelationDefinitions() {
    return this.correlationDefinitionList;
  }

  public List<ToPartDefinition> getToPartDefinitions() {
    return this.toPartDefinitionList;
  }

  public QName getFaultName() {
    return this.faultName;
  }

}
