/**
 * Copyright (C) 2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.def.impl;

import org.ow2.orchestra.facade.CopyUtil;
import org.ow2.orchestra.facade.def.CorrelationSetDefinition;
import org.ow2.orchestra.facade.def.OnAlarmDefinition;
import org.ow2.orchestra.facade.def.OnEventDefinition;
import org.ow2.orchestra.facade.def.PartnerLinkDefinition;
import org.ow2.orchestra.facade.def.ScopeActivityDefinition;
import org.ow2.orchestra.facade.def.VariableDefinition;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;

import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Alfonso Fuca, S. Ali Tokmen
 */
@XmlRootElement(name = "scope")
public class ScopeActivityDefinitionImpl extends BpelActivityWithSingleChildDefinitionImpl implements ScopeActivityDefinition {

  private static final long serialVersionUID = 6093998771288082618L;
  @XmlElement
  protected boolean exitOnStandardFault;
  @XmlElementWrapper
  @XmlAnyElement(lax = true)
  protected List<VariableDefinition> variables;
  @XmlElementWrapper
  @XmlAnyElement(lax = true)
  protected List<CorrelationSetDefinition> correlationSets;
  @XmlElementWrapper
  @XmlAnyElement(lax = true)
  protected List<PartnerLinkDefinition> partnerLinks;
  @XmlElementWrapper
  @XmlAnyElement(lax = true)
  protected List<OnEventDefinition> onEvents;
  @XmlElementWrapper
  @XmlAnyElement(lax = true)
  protected List<OnAlarmDefinition> onAlarms;
  @XmlElement
  protected List<String> messageExchanges;
  @XmlElement
  protected List<ActivityDefinitionUUID> faultHandlerUUIDs = null;
  @XmlElement
  protected ActivityDefinitionUUID terminationHandlerUUID = null;
  @XmlElement
  protected ActivityDefinitionUUID compensationHandlerUUID = null;

  protected ScopeActivityDefinitionImpl() {
  }

  public ScopeActivityDefinitionImpl(final ScopeActivityDefinition record) {
    super(record);
    this.exitOnStandardFault = record.getExitOnStandardFault();
    this.variables = CopyUtil.copyList(record.getVariables());
    this.correlationSets = CopyUtil.copyList(record.getCorrelationSets());
    this.partnerLinks = CopyUtil.copyList(record.getPartnerLinks());
    this.onAlarms = CopyUtil.copyList(record.getOnAlarmEventHandlers());
    this.onEvents = CopyUtil.copyList(record.getOnEventEventHandlers());

    this.messageExchanges = new ArrayList<String>();
    for (final String messageExchange : record.getMessageExchanges()) {
      this.messageExchanges.add(messageExchange);
    }
    this.faultHandlerUUIDs = new ArrayList<ActivityDefinitionUUID>();
    for (final ActivityDefinitionUUID faultHandlerUUID : record.getFaultHandlerUUIDs()) {
      this.faultHandlerUUIDs.add(new ActivityDefinitionUUID(faultHandlerUUID));
    }
    this.terminationHandlerUUID = new ActivityDefinitionUUID(record.getTerminationHandlerDefinitionUUID());
    this.compensationHandlerUUID = new ActivityDefinitionUUID(record.getCompensationHandlerDefinitionUUID());
  }

  public ActivityType getType() {
    return ActivityType.SCOPE;
  }

  public boolean getExitOnStandardFault() {
    return this.exitOnStandardFault;
  }

  public List<VariableDefinition> getVariables() {
    return this.variables;
  }

  public List<CorrelationSetDefinition> getCorrelationSets() {
    return this.correlationSets;
  }

  public List<PartnerLinkDefinition> getPartnerLinks() {
    return this.partnerLinks;
  }

  public List<String> getMessageExchanges() {
    return this.messageExchanges;
  }

  public List<ActivityDefinitionUUID> getFaultHandlerUUIDs() {
    return this.faultHandlerUUIDs;
  }

  public ActivityDefinitionUUID getTerminationHandlerDefinitionUUID() {
    return this.terminationHandlerUUID;
  }

  public ActivityDefinitionUUID getCompensationHandlerDefinitionUUID() {
    return this.compensationHandlerUUID;
  }

  public List<OnAlarmDefinition> getOnAlarmEventHandlers() {
    return this.onAlarms;
  }

  public List<OnEventDefinition> getOnEventEventHandlers() {
    return this.onEvents;
  }
}
