/*******************************************************************************
 * Copyright (C) 2011  Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 *******************************************************************************/
package org.ow2.orchestra.facade.rest;

import org.ow2.orchestra.facade.data.runtime.JobData;
import org.ow2.orchestra.facade.data.runtime.PendingMessageData;
import org.ow2.orchestra.facade.exception.InstanceNotFoundException;
import org.ow2.orchestra.facade.exception.JobNotFoundException;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;

import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;

/**
 * @author Guillaume Porcher
 */
@Path("/instanceManagement/")
public interface JaxRSInstanceManagementAPI {
  @POST
  @Path("/instance/{instanceUUID}/exit")
  void exit(@PathParam("instanceUUID") ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException;

  @POST
  @Path("/instance/{instanceUUID}/resume")
  void resume(@PathParam("instanceUUID") ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException;

  @POST
  @Path("/instance/{instanceUUID}/suspend")
  void suspend(@PathParam("instanceUUID") ProcessInstanceUUID processInstanceUUID) throws InstanceNotFoundException;

  @POST
  @Path("/instance/{instanceUUID}/remove")
  boolean remove(@PathParam("instanceUUID") ProcessInstanceUUID processInstanceUUID);

  @GET
  @Path("/failedJob")
  CollectionWrapper<JobData> findJobsWithException();

  @POST
  @Path("/failedJob/retry")
  void retryJob(@FormParam("job") JobData job, @FormParam("retries") int retries) throws JobNotFoundException;

  @GET
  @Path("/pendingMessage")
  CollectionWrapper<PendingMessageData> getPendingMessages();

  @DELETE
  @Path("/pendingMessage")
  void removePendingMessage(PendingMessageData message);
}
