/*
 * Copyright (C) 2012 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.facade.rest;

import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.ow2.orchestra.util.JAXBUtils;

/**
 * @author Loic Albertin
 */
@XmlRootElement(name="stringMapWrapper")
public class StringMapWrapper {

  /**
    * @author Guillaume Porcher
    */
    public static class Adapter extends JAXBUtils.JAXBMapAdapter<String, String, String> {
      public Adapter() {
      }
    }

  @XmlJavaTypeAdapter(Adapter.class)
  protected Map<String,String> content;

  public StringMapWrapper() {
  }

  public static StringMapWrapper make(Map<String, String> source) {
    StringMapWrapper wrapper = new StringMapWrapper();
    wrapper.content = source;
    return wrapper;
  }

  public Map<String, String> getContent() {
    return content;
  }
}
