/**
 * Copyright (C) 2008-2009 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime;

/**
 * Bpel activity types supported by Orchestra
 *
 * @author Alfonso Fuca
 */
public enum ActivityType {
  // Bpel activities
  ASSIGN(true),
  COMPENSATE(true),
  COMPENSATE_SCOPE(true),
  EMPTY(true),
  EXIT(true),
  EXTENSION_ACTIVITY(true),
  FLOW(true),
  FOR_EACH(true),
  IF(true),
  INVOKE(true),
  PICK(true),
  PROCESS(true),
  RECEIVE(true),
  REPEAT_UNTIL(true),
  REPLY(true),
  RETHROW(true),
  SCOPE(true),
  SEQUENCE(true),
  THROW(true),
  VALIDATE(true),
  WAIT(true),
  WHILE(true),
  // Non-Bpel activities (i.e. activities not defined in the Bpel
  // specifications as being activities but act as if they were activities)
  CATCH_HANDLER(true),
  CATCHALL_HANDLER(true),
  COMPENSATION_HANDLER(true),
  TERMINATION_HANDLER(true),
  SCOPE_EVENT_HANDLER(false),
  // Orchestra activities
  EXTENSION_TEST(true),
  // Orchestra extension activities
  EXTENSION(false),
  // This temporary type is used when persistence of activity is not written
  UNKNOWN_ACTIVITY(true);

  private final boolean isBpelActivity;

  public boolean isBpelActivity() {
    return isBpelActivity;
  }

  ActivityType(final boolean bpelActivity) {
    isBpelActivity = bpelActivity;
  }
}
