/**
 * Copyright (C) 2008 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 **/

package org.ow2.orchestra.facade.runtime;

import java.util.List;

import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;

/**
 * A process is considered as an activity. This is the subtype of activity
 * instance.
 * 
 * @author Alfonso Fuca, Guillaume Renault
 */
public interface ProcessInstance extends ScopeActivityInstance {

  /**
   * Returns the UUID of the process instance.
   * 
   * @return The UUID of the process instance.
   */
  ProcessInstanceUUID getUUID();

  /**
   * Returns the list of process instance states.
   * 
   * @return The list of process instance states.
   */
  List<ProcessInstanceStateUpdate> getProcessInstanceStateUpdate();

  /**
   * Update the process instance state list
   *
   * @param state
   *          the {@link ProcessInstanceStateUpdate} object
   */
  void addProcessInstanceState(ProcessInstanceStateUpdate state);

}
