package org.ow2.orchestra.facade.wsdl;

import org.ow2.orchestra.util.JAXBUtils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.wsdl.Definition;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * maintains the mappings between a namespace and a WSDL definition throughout
 * the whole bpel process deployment. The deployer will make a WsdlDefinitions
 * object available in the object stack of the {@link org.ow2.orchestra.pvm.internal.xml.Parse}.
 *
 * This mapping is used to find the wsdl definition when an import element
 * without a location attribute is used in a bpel process.
 *
 * <pre>
 * WsdlDefinitions wsdlDefinitions = parse.findObject(WsdlDefinitions.class);
 * </pre>
 *
 * @author Guillaume Porcher
 */
@XmlRootElement(name = "wsdlDefinitions")
public class WsdlDefinitions implements Serializable {

  private static final long serialVersionUID = 4597915313973522415L;

  /**
   * Default constructor.
   */
  public WsdlDefinitions() {
  }

  @XmlElement
  @XmlJavaTypeAdapter(JAXBUtils.JAXBMapDefinitionsAdapter.class)
  private Map<String, Set<Definition>> definitions = null;

  public void addWsdlDefinition(final String namespace, final Definition wsdlDefinition) {
    if (this.definitions == null) {
      this.definitions = new HashMap<String, Set<Definition>>();
    }
    if (!this.definitions.containsKey(namespace)) {
      this.definitions.put(namespace, new HashSet<Definition>());
    }
    this.definitions.get(namespace).add(wsdlDefinition);
  }

  public void removeWsdlDefinition(final String namespace) {
    if (this.definitions != null) {
      this.definitions.remove(namespace);
    }
  }

  public Set<Definition> getWsdlDefinitions(final String namespace) {
    if (this.definitions != null) {
      return this.definitions.get(namespace);
    }
    return null;
  }

  public Map<String, Set<Definition>> getWsdlDefinitions() {
    return this.definitions;
  }
}
