/*
 * Copyright (C) 2012 Bull S. A. S.
 * Bull, Rue Jean Jaures, B.P.68, 78340, Les Clayes-sous-Bois
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA  02110-1301, USA.
 */

package org.ow2.orchestra.util;

import java.util.Properties;

/**
 * @author Loic Albertin
 */
public class OrchestraUrlUtil {
  private static String getOrchestraURLPrefix(final Properties orchestraProperties) {
    return "http://"
      + orchestraProperties.getProperty(OrchestraConstants.SERVLET_HOST)
      + ":"
      + orchestraProperties.getProperty(OrchestraConstants.SERVLET_PORT)
      + "/"
      + orchestraProperties.getProperty(OrchestraConstants.SERVLET_PATH);
  }

  public static String replacePropertiesInOrchestraURL(final String url, final Properties orchestraProperties) {
    if (url == null) {
      return url;
    }
    // replace ORCHESTRA_WS_URL_KEY by url prefix
    final String url1 = url.replace(
        "${" + OrchestraConstants.ORCHESTRA_WS_URL_KEY + "}",
        getOrchestraURLPrefix(orchestraProperties));
    // replace HTTP_PORT_WS_URL_KEY
    final String url2 = url1.replace(
        "${" + OrchestraConstants.HTTP_PORT_WS_URL_KEY + "}",
        orchestraProperties.getProperty(OrchestraConstants.SERVLET_PORT));
    // replace SERVLET_PORT
    final String url3 = url2.replace(
        "${" + OrchestraConstants.SERVLET_PORT + "}",
        orchestraProperties.getProperty(OrchestraConstants.SERVLET_PORT));
    return url3;
  }
}
