/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.activities.foreach;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class ForEachTest
extends BpelTestCase {
    public ForEachTest() {
        super("http://orchestra.ow2.org/foreach", "foreach");
    }

    public void testForEach() {
        this.deploy();
        this.launch();
        this.undeploy();
    }

    public void testInvalidStartForEachDueToANegativeIndex() {
        this.deploy();
        BpelFaultException e = this.launchInvalid("-8", "6");
        Assert.assertNotNull((String)"InvalidExpressionValue expected", (Object)e);
        Assert.assertEquals((Object)BpelFaultException.BpelFault.invalidExpressionValue.getQName(), (Object)e.getFaultName());
        this.undeploy();
    }

    public void testInvalidStartForEachDueToANonNumberIndex() {
        this.deploy();
        BpelFaultException e = this.launchInvalid("abc", "3");
        Assert.assertNotNull((String)"InvalidExpressionValue expected", (Object)e);
        Assert.assertEquals((Object)BpelFaultException.BpelFault.invalidExpressionValue.getQName(), (Object)e.getFaultName());
        this.undeploy();
    }

    public void testInvalidStopForEachDueToANonNumberIndex() {
        this.deploy();
        BpelFaultException e = this.launchInvalid("1", "def");
        Assert.assertNotNull((String)"InvalidExpressionValue expected", (Object)e);
        Assert.assertEquals((Object)BpelFaultException.BpelFault.invalidExpressionValue.getQName(), (Object)e.getFaultName());
        this.undeploy();
    }

    public void deploy() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public void launch() {
        boolean start = true;
        int stop = 4;
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)Integer.toString(1)));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)Integer.toString(4)));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        final BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){
            private static final long serialVersionUID = 1624305940767648609L;

            public Object execute(Environment environment) throws Exception {
                MessageVariable reply = callResult.getMessageCarrier().getMessage();
                int countTotal = Integer.parseInt(reply.getPartValue("count").getTextContent());
                Assert.assertEquals((int)4, (int)countTotal);
                ForEachTest.this.deleteInstance(callResult);
                return null;
            }
        });
    }

    public BpelFaultException launchInvalid(String start, String stop) {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("start", BpelXmlUtil.createElementWithContent((String)start));
        parts.put("stop", BpelXmlUtil.createElementWithContent((String)stop));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "submit";
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "submit");
        BpelFaultException exception = this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), BpelFaultException.class);
        this.deleteInstances(1);
        return exception;
    }
}

