/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.faultManagement.catch_;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.WSRepository;
import org.ow2.orchestra.test.wsutils.FailWS;
import org.ow2.orchestra.test.wsutils.SaveWS;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatchTest
extends BpelTestCase {
    public CatchTest() {
        super("http://orchestra.ow2.org/catch_", "catch_");
    }

    public void testVariablesInFH() throws Exception {
        HashMap<String, Document> elements = new HashMap<String, Document>();
        elements.put("dummyElement", this.createElement("http://www.w3.org/2001/XMLSchema", "integer").getOwnerDocument());
        this.deploy("variables");
        this.launch(new QName("wsFault"), elements, "catchAll3var3catchAll2catchMissingVar");
        this.undeploy();
    }

    public void testFaultMatchingCatchAllWithinInvoke() throws Exception {
        this.deploy("Invoke");
        this.launch(null, null, "catchAll");
        this.undeploy();
    }

    public void testFaultMatchingCatchAllWithinScope() throws Exception {
        this.deploy("Scope");
        this.launch(null, null, "catchAll");
        this.undeploy();
    }

    public void testFaultWithoutVariableMatchingFaultNameWithinInvoke() throws Exception {
        this.deploy("Invoke");
        this.launch("FaultMatchingFaultName");
        this.undeploy();
    }

    public void testFaultWithoutVariableMatchingFaultNameWithinScope() throws Exception {
        this.deploy("Scope");
        this.launch("FaultMatchingFaultName");
        this.undeploy();
    }

    public void testFaultWithVariableMatchingFaultNameAndMessageTypeWithinInvoke() throws Exception {
        this.deploy("Invoke");
        this.launch("FaultMatchingFaultTypeAndFaultName", "dummyElement", this.createElement("http://www.w3.org/2001/XMLSchema", "integer"));
        this.undeploy();
    }

    public void testFaultWithVariableMatchingFaultNameAndMessageTypeWithinScope() throws Exception {
        this.deploy("Scope");
        this.launch("FaultMatchingFaultTypeAndFaultName", "dummyElement", this.createElement("http://www.w3.org/2001/XMLSchema", "integer"));
        this.undeploy();
    }

    public void testFaultVariableElementAndName() throws Exception {
        this.deploy("faultVariableElementAndName");
        this.launch("FaultMatchingFaultElementAndNamesomeRandomCatchRequest");
        this.undeploy();
    }

    public void testFaultWithVariableMatchingFaultNameOnlyWithinInvoke() throws Exception {
        this.deploy("Invoke");
        this.launch("FaultMatchingFaultName", "dummyElement", this.createElement());
        this.undeploy();
    }

    public void testFaultWithVariableMatchingFaultNameOnlyWithinScope() throws Exception {
        this.deploy("Scope");
        this.launch("FaultMatchingFaultName", "dummyElement", this.createElement());
        this.undeploy();
    }

    public void testFaultWithVariableMatchingFaultMessageTypeWithinInvoke() throws Exception {
        this.deploy("Invoke");
        this.launch("FaultMatchingFaultType", "dummyElement", this.createElement("http://www.w3.org/2001/XMLSchema", "integer"));
        this.undeploy();
    }

    public void testFaultWithVariableMatchingFaultMessageTypeWithinScope() throws Exception {
        this.deploy("Scope");
        this.launch("FaultMatchingFaultType", "dummyElement", this.createElement("http://www.w3.org/2001/XMLSchema", "integer"));
        this.undeploy();
    }

    public void testFaultVariableMessageTypeWithinInvoke() throws Exception {
        this.deploy("Invoke");
        this.launch("FaultVariableMatchingFaultType", "dummyElement", this.createElement("http://orchestra.ow2.org/catch_", "catch_Request"));
        this.undeploy();
    }

    public void testFaultVariableMessageTypeWithinScope() throws Exception {
        this.deploy("Scope");
        this.launch("FaultVariableMatchingFaultType", "dummyElement", this.createElement("http://orchestra.ow2.org/catch_", "catch_Request"));
        this.undeploy();
    }

    public void testFaultVariableElement() throws Exception {
        this.deploy("faultVariableElement");
        this.launch("FaultMatchingFaultElementsomeRandomCatchRequest");
        this.undeploy();
    }

    public void deploy(String suffix) {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + suffix + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
    }

    public void launch(String qname) {
        this.launch(new QName(qname), null, "catch" + qname);
    }

    public void launch(String qname, String elementName, Document element) {
        HashMap<String, Document> elements = new HashMap<String, Document>();
        elements.put(elementName, element);
        this.launch(new QName(qname), elements, "catch" + qname);
    }

    public void launch(QName faultName, Map<String, Document> faultParts, String responseMiddle) {
        String message = UUID.randomUUID().toString();
        String expectedResponse = message + responseMiddle + message;
        SaveWS saveWS = new SaveWS();
        WSRepository.addWS(SaveWS.PORTTYPE_QNAME, saveWS);
        FailWS failWS = new FailWS();
        WSRepository.addWS(FailWS.PORTTYPE_QNAME, failWS);
        if (faultName != null) {
            failWS.setExceptionFault(faultName, faultParts);
        } else {
            failWS.resetException();
        }
        HashMap<String, Element> parts = new HashMap<String, Element>();
        Element el = BpelXmlUtil.createElement((String)"http://orchestra.ow2.org/catch_", (String)"catch_Request");
        el.setTextContent(message);
        parts.put("input", el);
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        BpelTestCase.CallResult callResult = this.call(parts, portTypeQName, "start");
        this.waitForInstanceEnd(callResult.getProcessInstanceUUID());
        this.deleteInstances(1);
        WSRepository.removeWS(FailWS.PORTTYPE_QNAME);
        WSRepository.removeWS(SaveWS.PORTTYPE_QNAME);
        Assert.assertEquals((String)expectedResponse, (String)saveWS.getBuffer());
    }

    private Document createElement() {
        Element element = BpelXmlUtil.createElement((String)"dummyElement");
        return element.getOwnerDocument();
    }

    private Document createElement(String namespace, String localname) {
        Element element = BpelXmlUtil.createElement((QName)new QName(namespace, localname));
        element.setTextContent("dummyElement");
        return element.getOwnerDocument();
    }
}

