/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.axis.osgi;

import java.net.URL;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.Servlet;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.ow2.orchestra.axis.OrchestraBaseAxisServlet;
import org.ow2.orchestra.env.BpelEnvironmentParser;
import org.ow2.orchestra.jmx.JMXAgent;
import org.ow2.orchestra.pvm.env.EnvironmentFactory;
import org.ow2.orchestra.util.Misc;

public class Engine
implements Pojo {
    private InstanceManager __IM;
    private boolean __Faliases;
    private final Map<String, Servlet> aliases;
    private boolean __FhttpService;
    private HttpService httpService;
    private boolean __FenvironmentLocation;
    private String environmentLocation;
    private boolean __FjmxAgent;
    private JMXAgent jmxAgent;
    private boolean __MsetEnvironment$java_lang_String;
    private boolean __MgetEnvironment;
    private boolean __MgetHttpService;
    private boolean __MsetHttpService$org_osgi_service_http_HttpService;
    private boolean __Mstart;
    private boolean __Mstop;

    Map __getaliases() {
        if (!this.__Faliases) {
            return this.aliases;
        }
        return (Map)this.__IM.onGet((Object)this, "aliases");
    }

    void __setaliases(Map map) {
        if (!this.__Faliases) {
            this.aliases = map;
            return;
        }
        this.__IM.onSet((Object)this, "aliases", (Object)map);
    }

    HttpService __gethttpService() {
        if (!this.__FhttpService) {
            return this.httpService;
        }
        return (HttpService)this.__IM.onGet((Object)this, "httpService");
    }

    void __sethttpService(HttpService httpService) {
        if (!this.__FhttpService) {
            this.httpService = httpService;
            return;
        }
        this.__IM.onSet((Object)this, "httpService", (Object)httpService);
    }

    String __getenvironmentLocation() {
        if (!this.__FenvironmentLocation) {
            return this.environmentLocation;
        }
        return (String)this.__IM.onGet((Object)this, "environmentLocation");
    }

    void __setenvironmentLocation(String string) {
        if (!this.__FenvironmentLocation) {
            this.environmentLocation = string;
            return;
        }
        this.__IM.onSet((Object)this, "environmentLocation", (Object)string);
    }

    JMXAgent __getjmxAgent() {
        if (!this.__FjmxAgent) {
            return this.jmxAgent;
        }
        return (JMXAgent)this.__IM.onGet((Object)this, "jmxAgent");
    }

    void __setjmxAgent(JMXAgent jMXAgent) {
        if (!this.__FjmxAgent) {
            this.jmxAgent = jMXAgent;
            return;
        }
        this.__IM.onSet((Object)this, "jmxAgent", (Object)jMXAgent);
    }

    public Engine() {
        this(null);
    }

    private Engine(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__sethttpService(null);
        this.__setenvironmentLocation(null);
        this.__setaliases(new HashMap());
    }

    public void setEnvironment(String string) {
        if (!this.__MsetEnvironment$java_lang_String) {
            this.__setEnvironment(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setEnvironment$java_lang_String", new Object[]{string});
            this.__setEnvironment(string);
            this.__IM.onExit((Object)this, "setEnvironment$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setEnvironment$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setEnvironment(String environmentLocation) {
        this.__setenvironmentLocation(environmentLocation);
    }

    public String getEnvironment() {
        String string;
        if (!this.__MgetEnvironment) {
            return this.__getEnvironment();
        }
        try {
            this.__IM.onEntry((Object)this, "getEnvironment", new Object[0]);
            string = this.__getEnvironment();
            this.__IM.onExit((Object)this, "getEnvironment", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getEnvironment", throwable);
            throw throwable;
        }
        return string;
    }

    private String __getEnvironment() {
        return this.__getenvironmentLocation();
    }

    public HttpService getHttpService() {
        HttpService httpService;
        if (!this.__MgetHttpService) {
            return this.__getHttpService();
        }
        try {
            this.__IM.onEntry((Object)this, "getHttpService", new Object[0]);
            httpService = this.__getHttpService();
            this.__IM.onExit((Object)this, "getHttpService", (Object)httpService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getHttpService", throwable);
            throw throwable;
        }
        return httpService;
    }

    private HttpService __getHttpService() {
        return this.__gethttpService();
    }

    public void setHttpService(HttpService httpService) {
        if (!this.__MsetHttpService$org_osgi_service_http_HttpService) {
            this.__setHttpService(httpService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setHttpService$org_osgi_service_http_HttpService", new Object[]{httpService});
            this.__setHttpService(httpService);
            this.__IM.onExit((Object)this, "setHttpService$org_osgi_service_http_HttpService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setHttpService$org_osgi_service_http_HttpService", throwable);
            throw throwable;
        }
    }

    private void __setHttpService(HttpService httpService) {
        this.__sethttpService(httpService);
    }

    public void start() throws Throwable {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() throws Throwable {
        ClassLoader bundleClassLoader = this.getClass().getClassLoader();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bundleClassLoader);
        try {
            Misc.log((Level)Level.FINEST, (String)"%s starting", (Object[])new Object[]{this.getClass().getName()});
            if (this.__getenvironmentLocation() == null) {
                Misc.log((Level)Level.WARNING, (String)"Can't get the environmentLocation from OSGi config, using internal environment. This may not be what you are expecting. If this is the case, please read your OSGi implementation documentation about ConfigAdmin service.", (Object[])new Object[0]);
                Misc.unreachableStatement((String)"Implement the default behaviour which take the environment from the bundle.");
            }
            Misc.log((Level)Level.INFO, (String)"Environment will be taken from: %s", (Object[])new Object[]{this.__getenvironmentLocation()});
            URL url = new URL(this.__getenvironmentLocation());
            EnvironmentFactory envFactory = BpelEnvironmentParser.parseEnvironmentFactoryFromURL((URL)url);
            Properties orchestraProperties = (Properties)envFactory.get("orchestra-properties");
            String servletPath = orchestraProperties.getProperty("orchestra.servlet.path");
            HttpContext context = this.__gethttpService().createDefaultHttpContext();
            Misc.log((Level)Level.FINEST, (String)("Context created: " + context), (Object[])new Object[0]);
            this.__gethttpService().registerResources("/", "index.html", context);
            OrchestraBaseAxisServlet servlet = new OrchestraBaseAxisServlet();
            Misc.log((Level)Level.FINEST, (String)"Servlet created: %s", (Object[])new Object[]{servlet});
            Hashtable<String, String> initparams = new Hashtable<String, String>();
            ((Dictionary)initparams).put("axis.servicesPath", servletPath + "/");
            ((Dictionary)initparams).put("axis.development.system", "true");
            this.__getaliases().put("/" + servletPath, servlet);
            for (Map.Entry mapping : this.__getaliases().entrySet()) {
                this.__gethttpService().registerServlet((String)mapping.getKey(), (Servlet)mapping.getValue(), initparams, context);
                Misc.log((Level)Level.INFO, (String)"Alias registered: %s for servlet: %s", (Object[])new Object[]{mapping.getKey(), mapping.getValue()});
            }
            this.__setjmxAgent(new JMXAgent());
            this.__getjmxAgent().startOrchestra(envFactory);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public void stop() throws Throwable {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() throws Throwable {
        ClassLoader bundleClassLoader = this.getClass().getClassLoader();
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(bundleClassLoader);
        try {
            Misc.log((Level)Level.FINEST, (String)"%s stopping", (Object[])new Object[]{this.getClass().getName()});
            for (String alias : this.__getaliases().keySet()) {
                this.__gethttpService().unregister(alias);
                Misc.log((Level)Level.INFO, (String)"Alias unregistered: %s", (Object[])new Object[]{alias});
            }
            this.__gethttpService().unregister("/");
            if (this.__getjmxAgent() != null) {
                this.__getjmxAgent().stopOrchestra();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("environmentLocation")) {
                this.__FenvironmentLocation = true;
            }
            if (set.contains("aliases")) {
                this.__Faliases = true;
            }
            if (set.contains("httpService")) {
                this.__FhttpService = true;
            }
            if (set.contains("jmxAgent")) {
                this.__FjmxAgent = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setEnvironment$java_lang_String")) {
                this.__MsetEnvironment$java_lang_String = true;
            }
            if (set.contains("getEnvironment")) {
                this.__MgetEnvironment = true;
            }
            if (set.contains("getHttpService")) {
                this.__MgetHttpService = true;
            }
            if (set.contains("setHttpService$org_osgi_service_http_HttpService")) {
                this.__MsetHttpService$org_osgi_service_http_HttpService = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

