/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.shell.remote;

import org.apache.felix.shell.ShellService;
import org.apache.felix.shell.remote.Latch;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

class ServiceMediator {
    private BundleContext m_BundleContext;
    private ShellService m_FelixShellService;
    private Latch m_FelixShellServiceLatch;
    private LogService m_LogService;
    private Latch m_LogServiceLatch;
    public static long WAIT_UNLIMITED = -1L;
    public static long NO_WAIT = 0L;
    static /* synthetic */ Class class$org$apache$felix$shell$ShellService;
    static /* synthetic */ Class class$org$osgi$service$log$LogService;

    ServiceMediator() {
    }

    public ShellService getFelixShellService(long wait) {
        try {
            if (wait < 0L) {
                this.m_FelixShellServiceLatch.acquire();
            } else if (wait > 0L) {
                this.m_FelixShellServiceLatch.attempt(wait);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.err);
        }
        return this.m_FelixShellService;
    }

    public LogService getLogServiceLatch(long wait) {
        try {
            if (wait < 0L) {
                this.m_LogServiceLatch.acquire();
            } else if (wait > 0L) {
                this.m_LogServiceLatch.attempt(wait);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.err);
        }
        return this.m_LogService;
    }

    public void info(String msg) {
        if (this.m_LogService != null) {
            this.m_LogService.log(3, msg);
        } else {
            this.sysout(msg);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.m_LogService != null) {
            this.m_LogService.log(1, msg, t);
        } else {
            this.syserr(msg, t);
        }
    }

    public void error(String msg) {
        if (this.m_LogService != null) {
            this.m_LogService.log(1, msg);
        } else {
            this.syserr(msg, null);
        }
    }

    public void debug(String msg) {
        if (this.m_LogService != null) {
            this.m_LogService.log(4, msg);
        } else {
            this.sysout(msg);
        }
    }

    public void warn(String msg) {
        if (this.m_LogService != null) {
            this.m_LogService.log(2, msg);
        } else {
            this.syserr(msg, null);
        }
    }

    private void sysout(String msg) {
        StringBuffer sbuf = new StringBuffer();
        Bundle b = this.m_BundleContext.getBundle();
        sbuf.append(b.getHeaders().get("Bundle-Name"));
        sbuf.append(" [");
        sbuf.append(b.getBundleId());
        sbuf.append("] ");
        sbuf.append(msg);
        System.out.println(sbuf.toString());
    }

    private void syserr(String msg, Throwable t) {
        StringBuffer sbuf = new StringBuffer();
        Bundle b = this.m_BundleContext.getBundle();
        sbuf.append(b.getHeaders().get("Bundle-Name"));
        sbuf.append(" [");
        sbuf.append(b.getBundleId());
        sbuf.append("] ");
        sbuf.append(msg);
        System.err.println(sbuf.toString());
        if (t != null) {
            t.printStackTrace(System.err);
        }
    }

    public boolean activate(BundleContext bc) {
        this.m_BundleContext = bc;
        this.m_FelixShellServiceLatch = this.createWaitLatch();
        this.m_LogServiceLatch = this.createWaitLatch();
        ServiceListenerImpl serviceListener = new ServiceListenerImpl();
        String filter = "(objectclass=" + (class$org$apache$felix$shell$ShellService == null ? (class$org$apache$felix$shell$ShellService = ServiceMediator.class$("org.apache.felix.shell.ShellService")) : class$org$apache$felix$shell$ShellService).getName() + ")";
        try {
            filter = "(|" + filter + "(objectclass=" + (class$org$osgi$service$log$LogService == null ? (class$org$osgi$service$log$LogService = ServiceMediator.class$("org.osgi.service.log.LogService")) : class$org$osgi$service$log$LogService).getName() + "))";
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            bc.addServiceListener((ServiceListener)serviceListener, filter);
            ServiceReference[] srl = bc.getServiceReferences(null, filter);
            for (int i = 0; srl != null && i < srl.length; ++i) {
                serviceListener.serviceChanged(new ServiceEvent(1, srl[i]));
            }
        }
        catch (InvalidSyntaxException ex) {
            ex.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public void deactivate() {
        this.m_FelixShellService = null;
        this.m_FelixShellServiceLatch = null;
        this.m_BundleContext = null;
    }

    private Latch createWaitLatch() {
        return new Latch();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ServiceListenerImpl
    implements ServiceListener {
        private ServiceListenerImpl() {
        }

        public void serviceChanged(ServiceEvent ev) {
            ServiceReference sr = ev.getServiceReference();
            Object o = null;
            switch (ev.getType()) {
                case 1: {
                    o = ServiceMediator.this.m_BundleContext.getService(sr);
                    if (o == null) {
                        return;
                    }
                    if (o instanceof ShellService) {
                        ServiceMediator.this.m_FelixShellService = (ShellService)o;
                        ServiceMediator.this.m_FelixShellServiceLatch.release();
                        break;
                    }
                    if (o instanceof LogService) {
                        ServiceMediator.this.m_LogService = (LogService)o;
                        ServiceMediator.this.m_LogServiceLatch.release();
                        break;
                    }
                    ServiceMediator.this.m_BundleContext.ungetService(sr);
                    break;
                }
                case 4: {
                    o = ServiceMediator.this.m_BundleContext.getService(sr);
                    if (o == null) {
                        return;
                    }
                    if (o instanceof ShellService) {
                        ServiceMediator.this.m_FelixShellService = null;
                        ServiceMediator.this.m_FelixShellServiceLatch = ServiceMediator.this.createWaitLatch();
                        break;
                    }
                    if (o instanceof LogService) {
                        ServiceMediator.this.m_LogService = null;
                        ServiceMediator.this.m_LogServiceLatch = ServiceMediator.this.createWaitLatch();
                        break;
                    }
                    ServiceMediator.this.m_BundleContext.ungetService(sr);
                }
            }
        }
    }
}

