/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.remote.querier;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import junit.framework.Assert;
import org.ow2.orchestra.facade.QuerierRuntimeAPI;
import org.ow2.orchestra.facade.def.ProcessDefinition;
import org.ow2.orchestra.facade.exception.OrchestraException;
import org.ow2.orchestra.facade.jmx.RemoteDeployerMBean;
import org.ow2.orchestra.facade.runtime.ActivityInstance;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.ProcessInstance;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.test.remote.RemoteTestCase;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.SOAPUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APITest
extends RemoteTestCase {
    private static final long TEST_TIMEOUT = 40000L;
    private static final String NAME_SPACE = "http://orchestra.ow2.org/tests/querier/";

    @Override
    public ProcessDefinition deploy(String processName) {
        return this.deploy(processName, Collections.singletonList(((Object)((Object)this)).getClass().getResource("apitest.wsdl")));
    }

    public void undeploy(String processName) {
        this.undeploy(new QName(NAME_SPACE, processName));
    }

    public Future<SOAPMessage> startProcess(String processName) {
        String operationName = "submit";
        String part = "<inv>bidon</inv>";
        final SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/querier/submit", (String)"<inv>bidon</inv>");
        final String endpoint = this.getDefaultEndpoint("querierPort");
        FutureTask<SOAPMessage> futureTask = new FutureTask<SOAPMessage>(new Callable<SOAPMessage>(){

            @Override
            public SOAPMessage call() {
                return SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            }
        });
        new Thread(futureTask).start();
        return futureTask;
    }

    public Future<SOAPMessage> continueProcess(String processName) {
        String operationName = "submit";
        String part = "<inv>bidon</inv>";
        final SOAPMessage request = SOAPUtil.buildDocumentSOAPMessage((String)"http://orchestra.ow2.org/tests/querier/submit", (String)"<inv>bidon</inv>");
        final String endpoint = this.getDefaultEndpoint("querierContinuePort");
        FutureTask<SOAPMessage> futureTask = new FutureTask<SOAPMessage>(new Callable<SOAPMessage>(){

            @Override
            public SOAPMessage call() {
                return SOAPUtil.call((SOAPMessage)request, (String)endpoint);
            }
        });
        new Thread(futureTask).start();
        return futureTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFindProcessInstances() throws Exception {
        long testStartTime = System.currentTimeMillis();
        String processName = "apitest1";
        this.deploy("apitest1");
        try {
            RemoteDeployerMBean remoteDeployer = (RemoteDeployerMBean)Misc.getMBeanProxy(RemoteDeployerMBean.class, (String)this.jmxServiceUrl, (String)this.jmxObjectName);
            int initialRunned = remoteDeployer.findProcessInstances(ActivityState.FINISHED).size();
            Set previousRunningProcess = remoteDeployer.findProcessInstances(ActivityState.RUNNING);
            Set previousExitedProcess = remoteDeployer.findProcessInstances(ActivityState.EXITED);
            Future<SOAPMessage> soapMessageFutureStart = this.startProcess("apitest1");
            Future<SOAPMessage> soapMessageFutureContinue = this.continueProcess("apitest1");
            long timeout = testStartTime + 40000L - System.currentTimeMillis();
            if (timeout <= 0L) {
                Assert.fail((String)"timeout");
            }
            soapMessageFutureContinue.get(timeout, TimeUnit.MILLISECONDS);
            Set runningProcess = remoteDeployer.findProcessInstances(ActivityState.RUNNING);
            Assert.assertEquals((String)"No new process found", (int)(previousRunningProcess.size() + 1), (int)runningProcess.size());
            Iterator it = runningProcess.iterator();
            ProcessInstanceUUID processInstanceUUID = null;
            while (it.hasNext()) {
                ProcessInstance processInstance = (ProcessInstance)it.next();
                if (previousRunningProcess.contains(processInstance)) continue;
                processInstanceUUID = processInstance.getUUID();
                break;
            }
            Assert.assertNotNull(processInstanceUUID);
            int expectedRunned = 8;
            this.assertOnActivityInstances((QuerierRuntimeAPI)remoteDeployer, processInstanceUUID, expectedRunned, 6);
            soapMessageFutureContinue = this.continueProcess("apitest1");
            timeout = testStartTime + 40000L - System.currentTimeMillis();
            if (timeout <= 0L) {
                Assert.fail((String)"timeout");
            }
            soapMessageFutureContinue.get(timeout, TimeUnit.MILLISECONDS);
            timeout = testStartTime + 40000L - System.currentTimeMillis();
            if (timeout <= 0L) {
                Assert.fail((String)"timeout");
            }
            soapMessageFutureStart.get(timeout, TimeUnit.MILLISECONDS);
            this.assertOnActivityInstances((QuerierRuntimeAPI)remoteDeployer, processInstanceUUID, expectedRunned += 9, 0);
            this.assertOnProcessInstances((QuerierRuntimeAPI)remoteDeployer, initialRunned + 1, previousRunningProcess.size(), previousExitedProcess.size());
        }
        finally {
            this.undeploy("apitest1");
        }
    }

    public void assertOnActivityInstances(QuerierRuntimeAPI querierRuntimeAPI, ProcessInstanceUUID processUUID, int expectedRunned, int expectedRunning) throws OrchestraException {
        Set activityInstanceBeforeTotalSet = querierRuntimeAPI.findActivityInstances(processUUID);
        int beforeTotalActivity = activityInstanceBeforeTotalSet.size();
        if (beforeTotalActivity > expectedRunned + expectedRunning) {
            Assert.fail((String)("Some activities may be duplicated : " + activityInstanceBeforeTotalSet));
        }
        Set activityInstanceRunningSet = querierRuntimeAPI.findActivityInstances(processUUID, ActivityState.RUNNING);
        Set activityInstanceRunnedSet = querierRuntimeAPI.findActivityInstances(processUUID, ActivityState.FINISHED);
        Set activityInstanceTotalSet = querierRuntimeAPI.findActivityInstances(processUUID);
        int totalActivity = activityInstanceTotalSet.size();
        if (totalActivity > expectedRunned + expectedRunning) {
            Assert.fail((String)("Some activities may be duplicated : " + activityInstanceTotalSet));
        }
        int runningActivity = activityInstanceRunningSet.size();
        int runnedActivity = activityInstanceRunnedSet.size();
        Assert.assertEquals((String)"Wrong number of running activities", (int)expectedRunning, (int)runningActivity);
        Assert.assertEquals((String)"Wrong number of runned activities", (int)expectedRunned, (int)runnedActivity);
        int totalRun = this.calculTotalActivities(activityInstanceRunningSet, activityInstanceRunnedSet);
        Assert.assertTrue((String)("Issue in find requests (" + beforeTotalActivity + "," + totalRun + "[" + runnedActivity + "+" + runningActivity + "]" + "," + totalActivity + ")"), (beforeTotalActivity <= totalRun && totalRun <= totalActivity ? 1 : 0) != 0);
    }

    private int calculTotalActivities(Set<ActivityInstance> ... activityInstanceSets) {
        HashSet<ActivityInstanceUUID> activityInstanceUUIDSet = new HashSet<ActivityInstanceUUID>();
        for (Set<ActivityInstance> activityInstanceSet : activityInstanceSets) {
            for (ActivityInstance activityInstance : activityInstanceSet) {
                activityInstanceUUIDSet.add(activityInstance.getUUID());
            }
        }
        return activityInstanceUUIDSet.size();
    }

    public void assertOnProcessInstances(QuerierRuntimeAPI querierRuntimeAPI, int runned, int running, int exited) {
        int beforeTotalInstance = querierRuntimeAPI.findProcessInstances().size();
        Set processInstanceRunnedSet = querierRuntimeAPI.findProcessInstances(ActivityState.FINISHED);
        Set processInstanceRunningSet = querierRuntimeAPI.findProcessInstances(ActivityState.RUNNING);
        Set processInstanceExitedSet = querierRuntimeAPI.findProcessInstances(ActivityState.EXITED);
        int totalInstance = querierRuntimeAPI.findProcessInstances().size();
        int runningInstance = processInstanceRunningSet.size();
        int runnedInstance = processInstanceRunnedSet.size();
        int exitedInstance = processInstanceExitedSet.size();
        Assert.assertEquals((int)running, (int)runningInstance);
        Assert.assertEquals((int)runned, (int)runnedInstance);
        Assert.assertEquals((int)exited, (int)exitedInstance);
        int totalRun = runnedInstance + runningInstance + exitedInstance;
        Assert.assertTrue((String)("beforeTotalInstance " + beforeTotalInstance + "> totalRun " + totalRun), (beforeTotalInstance <= totalRun ? 1 : 0) != 0);
        Assert.assertTrue((String)("totalRun " + totalRun + "> totalInstance " + totalInstance), (totalRun <= totalInstance ? 1 : 0) != 0);
    }
}

