/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.correlation.pickCorrelation;

import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.test.BpelTestCase;
import org.ow2.orchestra.test.correlation.CorrelationTestCase;
import org.ow2.orchestra.util.BpelXmlUtil;
import org.ow2.orchestra.var.MessageVariable;
import org.w3c.dom.Element;

public class PickCorrelationTest
extends CorrelationTestCase {
    public PickCorrelationTest() {
        super("http://orchestra.ow2.org/pickCorrelation", "pickCorrelation", BpelTestCase.EnvironmentType.JOURNAL);
    }

    protected BpelTestCase.CallResult makeCall(String firstName, String lastName, Boolean change) {
        HashMap<String, Element> parts = new HashMap<String, Element>();
        parts.put("firstName", BpelXmlUtil.createElementWithContent((String)firstName));
        parts.put("lastName", BpelXmlUtil.createElementWithContent((String)lastName));
        parts.put("change", BpelXmlUtil.createElementWithContent((String)change.toString()));
        QName portTypeQName = new QName(this.getProcessNamespace(), this.getProcessName() + "PT");
        String operationName = "pickCorrelation";
        return this.call(parts, portTypeQName, "pickCorrelation");
    }

    public void testPickCorrelationOK() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        String firstName = "myFirstName";
        String lastName = "myLastName";
        final BpelTestCase.CallResult result = this.makeCall("myFirstName", "myLastName", false);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                MessageVariable reply = result.getMessageCarrier().getMessage();
                Assert.assertNotNull((Object)reply);
                Element firstNameEl = reply.getPartValue("firstName");
                Assert.assertNotNull((Object)firstNameEl);
                Assert.assertEquals((String)"myFirstName", (String)firstNameEl.getTextContent());
                Element lastNameElement = reply.getPartValue("lastName");
                Assert.assertNotNull((Object)lastNameElement);
                Assert.assertEquals((String)"myLastName", (String)lastNameElement.getTextContent());
                PickCorrelationTest.this.deleteInstance(result);
                return null;
            }
        });
        this.undeploy();
    }

    public void testPickBadCorrelation() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        BpelTestCase.CallResult callResult = this.makeCall("firstName", "lastName", true);
        BpelFaultException bfe = this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), BpelFaultException.BpelFault.correlationViolation);
        this.deleteInstances(1);
        Assert.assertNotNull((Object)bfe);
        this.undeploy();
    }

    public void testPickCorrelationInitiate() {
        this.deploy(((Object)((Object)this)).getClass().getResource(this.getProcessName() + "Initiate.bpel"), ((Object)((Object)this)).getClass().getResource(this.getProcessName() + ".wsdl"));
        BpelTestCase.CallResult callResult = this.makeCall("firstName", "lastName", false);
        BpelFaultException bfe = this.waitForExceptionInInstance(callResult.getProcessInstanceUUID(), BpelFaultException.BpelFault.correlationViolation);
        this.deleteInstances(1);
        Assert.assertNotNull((Object)bfe);
        this.undeploy();
    }
}

