/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services;

import java.util.ArrayList;
import java.util.List;
import org.ow2.orchestra.facade.data.runtime.ActivityInstanceData;
import org.ow2.orchestra.facade.data.runtime.CorrelationSetInitializedData;
import org.ow2.orchestra.facade.data.runtime.ForeachInitializedData;
import org.ow2.orchestra.facade.data.runtime.PartnerLinkUpdateData;
import org.ow2.orchestra.facade.data.runtime.ProcessInstanceData;
import org.ow2.orchestra.facade.data.runtime.ScopeStateUpdateData;
import org.ow2.orchestra.facade.data.runtime.TimerData;
import org.ow2.orchestra.facade.data.runtime.TransitionConditionUpdateData;
import org.ow2.orchestra.facade.data.runtime.VariableUpdateData;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.exception.BpelFaultException;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.services.Archivable;
import org.ow2.orchestra.services.Recorder;
import org.ow2.orchestra.test.services.RecordSteps;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRecorder
implements Recorder {
    private static List<RecordSteps> results;
    private static List<ActivityInstanceUUID> activityUUIDStarted;
    private static List<ActivityInstanceUUID> activityUUIDEnded;
    private static List<Pair<ActivityInstanceUUID, Exception>> activityExceptionOccured;
    private static List<Pair<ActivityInstanceUUID, ActivityInstanceUUID>> activityFaultHandlerStarted;
    private static List<Pair<ActivityInstanceUUID, ActivityInstanceUUID>> activityTerminationHandlerStarted;
    private static List<Pair<ActivityInstanceUUID, ActivityInstanceUUID>> activityCompensationHandlerStarted;

    public void recordActivityEnded(ActivityInstanceData activityInstanceData) {
        ActivityInstanceUUID activityUUID = activityInstanceData.getUUID();
        RecordSteps recordSteps = new RecordSteps("recordActivityEnded");
        recordSteps.setUUID(activityUUID);
        results.add(recordSteps);
        activityUUIDEnded.add(activityUUID);
    }

    public void recordExceptionOccured(ActivityInstanceUUID activityInstanceUUID, BpelFaultException exception) {
        RecordSteps recordSteps = new RecordSteps("recordExceptionOccured");
        recordSteps.setUUID(activityInstanceUUID);
        results.add(recordSteps);
        activityExceptionOccured.add(new Pair<ActivityInstanceUUID, BpelFaultException>(activityInstanceUUID, exception));
    }

    public void recordActivityStarted(ActivityInstanceData activityInstanceData) {
        ProcessDefinitionUUID processUUID = activityInstanceData.getActivityDefinitionData().getProcessDefinitionData().getUUID();
        ProcessInstanceUUID instanceUUID = activityInstanceData.getProcessInstanceData().getUUID();
        ActivityInstanceUUID activityUUID = activityInstanceData.getUUID();
        ActivityInstanceUUID encloserInstanceUUID = activityInstanceData.getEncloserUUID();
        RecordSteps recordSteps = new RecordSteps("recordActivityStarted");
        recordSteps.setUUID(processUUID);
        recordSteps.setUUID(instanceUUID);
        recordSteps.setUUID(activityUUID);
        recordSteps.setEncloserInstanceUUID(encloserInstanceUUID);
        results.add(recordSteps);
        activityUUIDStarted.add(activityUUID);
    }

    public void recordInstanceEnded(ProcessInstanceData processInstanceData) {
        ProcessInstanceUUID instanceUUID = processInstanceData.getUUID();
        RecordSteps recordSteps = new RecordSteps("recordInstanceEnded");
        recordSteps.setUUID(instanceUUID);
        results.add(recordSteps);
    }

    public void recordInstanceStarted(ProcessInstanceData processInstanceData) {
        ProcessDefinitionUUID processUUID = processInstanceData.getProcessDefinitionData().getUUID();
        ProcessInstanceUUID instanceUUID = processInstanceData.getUUID();
        RecordSteps recordSteps = new RecordSteps("recordInstanceStarted");
        recordSteps.setUUID(processUUID);
        recordSteps.setUUID(instanceUUID);
        results.add(recordSteps);
    }

    public void recordInstanceUpdated(ProcessInstanceData processInstanceData) {
        ProcessDefinitionUUID processUUID = processInstanceData.getProcessDefinitionData().getUUID();
        ProcessInstanceUUID instanceUUID = processInstanceData.getUUID();
        RecordSteps recordSteps = new RecordSteps("recordInstanceUpdated");
        recordSteps.setUUID(processUUID);
        recordSteps.setUUID(instanceUUID);
        results.add(recordSteps);
    }

    public List<RecordSteps> getResults() {
        return results;
    }

    public List<ActivityInstanceUUID> getActivitiesUUIDStarted() {
        return activityUUIDStarted;
    }

    public List<ActivityInstanceUUID> getActivitiesUUIDEnded() {
        return activityUUIDEnded;
    }

    public List<Pair<ActivityInstanceUUID, Exception>> getActivitiesExceptionOccured() {
        return activityExceptionOccured;
    }

    public List<Pair<ActivityInstanceUUID, ActivityInstanceUUID>> getActivitiesFaultHandlerStarted() {
        return activityFaultHandlerStarted;
    }

    public List<Pair<ActivityInstanceUUID, ActivityInstanceUUID>> getActivitiesTerminationHandlerStarted() {
        return activityTerminationHandlerStarted;
    }

    public List<Pair<ActivityInstanceUUID, ActivityInstanceUUID>> getActivitiesCompensationHandlerStarted() {
        return activityCompensationHandlerStarted;
    }

    public static void initialiseResults() {
        results = new ArrayList<RecordSteps>();
        activityUUIDStarted = new ArrayList<ActivityInstanceUUID>();
        activityUUIDEnded = new ArrayList<ActivityInstanceUUID>();
        activityExceptionOccured = new ArrayList<Pair<ActivityInstanceUUID, Exception>>();
        activityFaultHandlerStarted = new ArrayList<Pair<ActivityInstanceUUID, ActivityInstanceUUID>>();
        activityTerminationHandlerStarted = new ArrayList<Pair<ActivityInstanceUUID, ActivityInstanceUUID>>();
        activityCompensationHandlerStarted = new ArrayList<Pair<ActivityInstanceUUID, ActivityInstanceUUID>>();
    }

    public void remove(Archivable archivable) {
    }

    public void recordTimerStarted(TimerData timerData) {
    }

    public void recordForeachInitialized(ForeachInitializedData foreachInitializedData) {
    }

    public void recordVariableUpdated(VariableUpdateData variableUpdateData) {
    }

    public void recordCorrelationSetInitialized(CorrelationSetInitializedData correlationSetInitializedData) {
    }

    public void recordPartnerLinkUpdated(PartnerLinkUpdateData partnerLinkUpdateData) {
    }

    public void recordTransitionConditionUpdated(TransitionConditionUpdateData transitionConditionUpdateData) {
    }

    public void recordScopeStateChanged(ScopeStateUpdateData scopeStateUpdateData) {
    }

    public void recordProcessDeployed(ProcessFullDefinition processFullDefinition) {
    }

    public void recordProcessUndeployed(ProcessDefinitionUUID processDefinitionUUID) {
    }

    public void recordActivityExited(ActivityInstanceData activityInstanceData) {
    }

    public void recordActivityTerminated(ActivityInstanceData activityInstanceData) {
    }

    public void recordEventStarted(ActivityInstanceData createRuntimeData) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Pair<Element1, Element2> {
        private final Element1 element1;
        private final Element2 element2;

        public Pair(Element1 element1, Element2 element2) {
            this.element1 = element1;
            this.element2 = element2;
        }

        public Element1 getElement1() {
            return this.element1;
        }

        public Element2 getElement2() {
            return this.element2;
        }
    }
}

