/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.test.services.runtime;

import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.ow2.orchestra.facade.runtime.ActivityType;
import org.ow2.orchestra.facade.runtime.full.ActivityFullInstance;
import org.ow2.orchestra.facade.runtime.full.ProcessFullInstance;
import org.ow2.orchestra.facade.runtime.full.impl.ProcessFullInstanceImpl;
import org.ow2.orchestra.facade.runtime.full.impl.UnknownActivityFullInstanceImpl;
import org.ow2.orchestra.facade.uuid.ActivityDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ActivityInstanceUUID;
import org.ow2.orchestra.facade.uuid.IdFactory;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.cmd.CommandService;
import org.ow2.orchestra.services.Querier;
import org.ow2.orchestra.test.EnvironmentTestCase;
import org.ow2.orchestra.util.Misc;

public abstract class AbstractQuerierTest
extends EnvironmentTestCase {
    private long nbProcessInstances;
    private long nbActivityInstances;

    public abstract void saveNewProcessInstance(ProcessFullInstance var1);

    public abstract void saveNewActivityInstance(ActivityFullInstance var1);

    public abstract void removeProcessInstance(ProcessFullInstance var1);

    public abstract Querier getQuerier();

    public void setNbProcessInstances(long nbProcessInstances) {
        this.nbProcessInstances = nbProcessInstances;
    }

    public long getNbProcessInstances() {
        return this.nbProcessInstances;
    }

    public void setNbActivityInstances(long nbActivityInstances) {
        this.nbActivityInstances = nbActivityInstances;
    }

    public long getNbActivityInstances() {
        return this.nbActivityInstances;
    }

    public void testFindProcessInstances() {
        ProcessDefinitionUUID processUUID = IdFactory.getNewProcessUUID((String)"http://www.example.org/QuerierTest/", (String)"queriertest1", (String)Misc.getHumanReadableId((String)""));
        ProcessInstanceUUID instanceUUID = new ProcessInstanceUUID(Misc.getUniqueId((String)"instance$"));
        ProcessFullInstanceImpl newProcessFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Set processFullInstanceSet = AbstractQuerierTest.this.getQuerier().findProcessInstances();
                AbstractQuerierTest.this.setNbProcessInstances(processFullInstanceSet.size());
                return null;
            }
        });
        this.saveNewProcessInstance((ProcessFullInstance)newProcessFullInstance);
        commandService.execute((Command)new Command<Object>((ProcessFullInstance)newProcessFullInstance){
            final /* synthetic */ ProcessFullInstance val$newProcessFullInstance;
            {
                this.val$newProcessFullInstance = processFullInstance;
            }

            public Object execute(Environment environment) {
                Set processFullInstanceSet = AbstractQuerierTest.this.getQuerier().findProcessInstances();
                Assert.assertEquals((long)(AbstractQuerierTest.this.getNbProcessInstances() + 1L), (long)processFullInstanceSet.size());
                ProcessFullInstance lastProcessFullInstance = null;
                for (ProcessFullInstance processFullInstance : processFullInstanceSet) {
                    if (!processFullInstance.getUUID().equals((Object)this.val$newProcessFullInstance.getUUID())) continue;
                    lastProcessFullInstance = processFullInstance;
                    break;
                }
                if (lastProcessFullInstance == null) {
                    Assert.fail((String)"process instance not found");
                }
                Assert.assertEquals((Object)this.val$newProcessFullInstance.getProcessDefinitionUUID(), (Object)lastProcessFullInstance.getProcessDefinitionUUID());
                Assert.assertEquals((Object)this.val$newProcessFullInstance.getProcessInstanceUUID(), (Object)lastProcessFullInstance.getProcessInstanceUUID());
                Assert.assertEquals((Object)this.val$newProcessFullInstance.getUUID(), (Object)lastProcessFullInstance.getUUID());
                return null;
            }
        });
        this.removeProcessInstance((ProcessFullInstance)newProcessFullInstance);
    }

    public void testGetProcessInstance() {
        ProcessDefinitionUUID processUUID = IdFactory.getNewProcessUUID((String)"http://www.example.org/QuerierTest/", (String)"queriertest1", (String)Misc.getHumanReadableId((String)""));
        ProcessInstanceUUID instanceUUID = new ProcessInstanceUUID(Misc.getUniqueId((String)"instance$"));
        ProcessFullInstanceImpl newProcessFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Set processFullInstanceSet = AbstractQuerierTest.this.getQuerier().findProcessInstances();
                AbstractQuerierTest.this.setNbProcessInstances(processFullInstanceSet.size());
                return null;
            }
        });
        this.saveNewProcessInstance((ProcessFullInstance)newProcessFullInstance);
        commandService.execute((Command)new Command<Object>((ProcessFullInstance)newProcessFullInstance){
            final /* synthetic */ ProcessFullInstance val$newProcessFullInstance;
            {
                this.val$newProcessFullInstance = processFullInstance;
            }

            public Object execute(Environment environment) {
                ProcessFullInstance lastProcessFullInstance = AbstractQuerierTest.this.getQuerier().getProcessInstance(this.val$newProcessFullInstance.getProcessInstanceUUID());
                Assert.assertNotNull((Object)lastProcessFullInstance);
                Assert.assertEquals((Object)this.val$newProcessFullInstance.getProcessDefinitionUUID(), (Object)lastProcessFullInstance.getProcessDefinitionUUID());
                Assert.assertEquals((Object)this.val$newProcessFullInstance.getProcessInstanceUUID(), (Object)lastProcessFullInstance.getProcessInstanceUUID());
                Assert.assertEquals((Object)this.val$newProcessFullInstance.getUUID(), (Object)lastProcessFullInstance.getUUID());
                return null;
            }
        });
        this.removeProcessInstance((ProcessFullInstance)newProcessFullInstance);
    }

    public void testGetActivityInstance() {
        ProcessDefinitionUUID processUUID = IdFactory.getNewProcessUUID((String)"http://www.example.org/QuerierTest/", (String)"queriertest1", (String)Misc.getHumanReadableId((String)""));
        final ProcessInstanceUUID instanceUUID = new ProcessInstanceUUID(Misc.getUniqueId((String)"instance$"));
        ProcessFullInstanceImpl newProcessFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Set processFullInstanceSet = AbstractQuerierTest.this.getQuerier().findProcessInstances();
                AbstractQuerierTest.this.setNbProcessInstances(processFullInstanceSet.size());
                Set activityFullInstanceSet = AbstractQuerierTest.this.getQuerier().findActivityInstances(instanceUUID);
                AbstractQuerierTest.this.setNbActivityInstances(activityFullInstanceSet.size());
                return null;
            }
        });
        this.saveNewProcessInstance((ProcessFullInstance)newProcessFullInstance);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Set processFullInstanceSet = AbstractQuerierTest.this.getQuerier().findProcessInstances();
                Assert.assertEquals((long)(AbstractQuerierTest.this.getNbProcessInstances() + 1L), (long)processFullInstanceSet.size());
                return null;
            }
        });
        final ActivityInstanceUUID activityInstanceUUID = IdFactory.getNewActivityInstanceUUID((ProcessInstanceUUID)instanceUUID);
        ActivityDefinitionUUID activityDefinitionUUID = IdFactory.getNewActivityDefinitionUUID((ProcessDefinitionUUID)processUUID, (int)1);
        UnknownActivityFullInstanceImpl newActivityFullInstance = new UnknownActivityFullInstanceImpl(activityInstanceUUID, activityDefinitionUUID, processUUID, instanceUUID);
        this.saveNewActivityInstance((ActivityFullInstance)newActivityFullInstance);
        commandService.execute((Command)new Command<Object>((ActivityFullInstance)newActivityFullInstance){
            final /* synthetic */ ActivityFullInstance val$newActivityFullInstance;
            {
                this.val$newActivityFullInstance = activityFullInstance;
            }

            public Object execute(Environment environment) {
                ActivityFullInstance lastActivityFullInstance = AbstractQuerierTest.this.getQuerier().getActivityInstance(activityInstanceUUID);
                Assert.assertEquals((Object)this.val$newActivityFullInstance.getProcessDefinitionUUID(), (Object)lastActivityFullInstance.getProcessDefinitionUUID());
                Assert.assertEquals((Object)this.val$newActivityFullInstance.getProcessInstanceUUID(), (Object)lastActivityFullInstance.getProcessInstanceUUID());
                Assert.assertEquals((Object)this.val$newActivityFullInstance.getUUID(), (Object)lastActivityFullInstance.getUUID());
                return null;
            }
        });
        this.removeProcessInstance((ProcessFullInstance)newProcessFullInstance);
    }

    public void testFindActivityInstances() {
        ProcessDefinitionUUID processUUID = IdFactory.getNewProcessUUID((String)"http://www.example.org/QuerierTest/", (String)"queriertest1", (String)Misc.getHumanReadableId((String)""));
        final ProcessInstanceUUID instanceUUID = new ProcessInstanceUUID(Misc.getUniqueId((String)"instance$"));
        ProcessFullInstanceImpl newProcessFullInstance = new ProcessFullInstanceImpl(instanceUUID, processUUID);
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Set processFullInstanceSet = AbstractQuerierTest.this.getQuerier().findProcessInstances();
                AbstractQuerierTest.this.setNbProcessInstances(processFullInstanceSet.size());
                Set activityFullInstanceSet = AbstractQuerierTest.this.getQuerier().findActivityInstances(instanceUUID);
                AbstractQuerierTest.this.setNbActivityInstances(activityFullInstanceSet.size());
                return null;
            }
        });
        this.saveNewProcessInstance((ProcessFullInstance)newProcessFullInstance);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                Set processFullInstanceSet = AbstractQuerierTest.this.getQuerier().findProcessInstances();
                Assert.assertEquals((long)(AbstractQuerierTest.this.getNbProcessInstances() + 1L), (long)processFullInstanceSet.size());
                return null;
            }
        });
        ActivityInstanceUUID activityInstanceUUID = IdFactory.getNewActivityInstanceUUID((ProcessInstanceUUID)instanceUUID);
        ActivityDefinitionUUID activityDefinitionUUID = IdFactory.getNewActivityDefinitionUUID((ProcessDefinitionUUID)processUUID, (int)1);
        UnknownActivityFullInstanceImpl newActivityFullInstance = new UnknownActivityFullInstanceImpl(activityInstanceUUID, activityDefinitionUUID, processUUID, instanceUUID);
        this.saveNewActivityInstance((ActivityFullInstance)newActivityFullInstance);
        commandService.execute((Command)new Command<Object>((ActivityFullInstance)newActivityFullInstance){
            final /* synthetic */ ActivityFullInstance val$newActivityFullInstance;
            {
                this.val$newActivityFullInstance = activityFullInstance;
            }

            public Object execute(Environment environment) {
                Set activityFullInstanceSet = AbstractQuerierTest.this.getQuerier().findActivityInstances(instanceUUID);
                Assert.assertEquals((long)(AbstractQuerierTest.this.getNbActivityInstances() + 2L), (long)activityFullInstanceSet.size());
                Iterator it = activityFullInstanceSet.iterator();
                ActivityFullInstance lastActivityFullInstance = (ActivityFullInstance)it.next();
                if (lastActivityFullInstance.getType().equals((Object)ActivityType.PROCESS)) {
                    lastActivityFullInstance = (ActivityFullInstance)it.next();
                }
                Assert.assertEquals((Object)this.val$newActivityFullInstance.getProcessDefinitionUUID(), (Object)lastActivityFullInstance.getProcessDefinitionUUID());
                Assert.assertEquals((Object)this.val$newActivityFullInstance.getProcessInstanceUUID(), (Object)lastActivityFullInstance.getProcessInstanceUUID());
                Assert.assertEquals((Object)this.val$newActivityFullInstance.getUUID(), (Object)lastActivityFullInstance.getUUID());
                return null;
            }
        });
        this.removeProcessInstance((ProcessFullInstance)newProcessFullInstance);
    }

    public void testGetNonExistentProcessInstance() {
        final ProcessInstanceUUID instanceUUID = new ProcessInstanceUUID(Misc.getUniqueId((String)"instance$"));
        CommandService commandService = (CommandService)this.getEnvironmentFactory().get(CommandService.class);
        commandService.execute((Command)new Command<Object>(){

            public Object execute(Environment environment) {
                ProcessFullInstance processInstance = AbstractQuerierTest.this.getQuerier().getProcessInstance(instanceUUID);
                Assert.assertNull((Object)processInstance);
                return null;
            }
        });
    }
}

