/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.deployment;

import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.facade.Deployment;
import org.ow2.orchestra.facade.def.full.ProcessFullDefinition;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.wsdl.WsdlDefinitions;
import org.ow2.orchestra.parsing.BpelParser;
import org.ow2.orchestra.parsing.binding.DefinitionKeeper;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.xml.Parse;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.handlers.UndeployedProcessHandler;
import org.ow2.orchestra.services.itf.Publisher;
import org.ow2.orchestra.services.itf.Repository;
import org.ow2.orchestra.util.EnvTool;
import org.ow2.orchestra.util.Misc;
import org.ow2.orchestra.util.Namespaces;
import org.ow2.orchestra.util.StyleSheetRepository;
import org.ow2.orchestra.wsdl.WsdlsInfos;
import org.xml.sax.InputSource;

public class Deployer {
    private BpelParser bpelParser = new BpelParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessFullDefinition deploy(Deployment bpelDeployment, Environment environment) {
        Misc.checkArgsNotNull(bpelDeployment, environment);
        Misc.log(Level.INFO, "Deploying BPEL deployment %s", bpelDeployment);
        InputSource bpel = bpelDeployment.getBpel();
        if (bpel == null) {
            throw new OrchestraRuntimeException("Unable to open BPEL Stream");
        }
        Parse parse = this.bpelParser.createParse();
        WsdlDefinitions wsdlDefinitions = bpelDeployment.getWsdlDefinitions();
        parse.pushObject(wsdlDefinitions);
        Namespaces namespaces = new Namespaces(parse);
        parse.pushObject(namespaces);
        ProcessFullDefinition processDefinition = null;
        StyleSheetRepository styleSheetRepository = bpelDeployment.getStyleSheetRepository();
        parse.pushObject(styleSheetRepository);
        WsdlsInfos wsdlInfos = new WsdlsInfos();
        parse.pushObject(wsdlInfos);
        BpelProcess bpelProcess = null;
        Repository repository = environment.get(Repository.class);
        DefinitionKeeper definitionKeeper = new DefinitionKeeper(repository.getNextProcessCount());
        parse.pushObject(definitionKeeper);
        try {
            bpelProcess = (BpelProcess)parse.setInputSource(bpel).execute().getDocumentObject();
        }
        finally {
            parse.popObject();
            parse.popObject();
            parse.popObject();
            parse.popObject();
            parse.popObject();
        }
        if (!parse.hasProblems()) {
            if (bpelProcess == null) {
                throw new OrchestraRuntimeException("Bpel Process null");
            }
            bpelProcess.staticAnalysisCheck(parse);
        }
        parse.checkProblems("bpel file");
        processDefinition = definitionKeeper.getProcessFullDefinition();
        EnvTool.getRecorder().recordProcessDeployed(processDefinition);
        QName processQName = bpelProcess.getQName();
        Publisher servicePublisher = environment.get(Publisher.class);
        BpelProcess oldBpelProcess = repository.getProcess(processQName);
        if (oldBpelProcess != null) {
            throw new OrchestraRuntimeException("Problem during deployment : process " + processQName + " already deployed");
        }
        repository.storeProcess(bpelProcess);
        servicePublisher.publishServices(bpelProcess, environment);
        Misc.log(Level.INFO, "BPEL process %s deployed.", processQName);
        return processDefinition;
    }

    public void undeploy(QName processQName, Environment environment) {
        Repository repository = environment.get(Repository.class);
        Publisher servicePublisher = environment.get(Publisher.class);
        List<BpelExecution> runningInstances = repository.getInstances(processQName);
        if (runningInstances != null && !runningInstances.isEmpty()) {
            throw new OrchestraRuntimeException("Problem during undeployment: " + runningInstances.size() + " instances  of process " + processQName + "  are still running");
        }
        BpelProcess bpelProcess = repository.removeProcess(processQName);
        if (bpelProcess == null) {
            throw new OrchestraRuntimeException("Problem during undeployment : process " + processQName + " not found");
        }
        servicePublisher.unpublishServices(bpelProcess, environment);
        EnvTool.getRecorder().recordProcessUndeployed(bpelProcess.getUUID());
        ProcessFullDefinition processDefinition = EnvTool.getQuerier().getProcessDefinition(bpelProcess.getUUID());
        UndeployedProcessHandler handler = EnvTool.get(UndeployedProcessHandler.class, "undeployed-process-handler");
        handler.handleUndeployedProcess(processDefinition);
        Misc.log(Level.INFO, "BPEL process %s undeployed.", processQName);
    }

    public void undeploy(ProcessDefinitionUUID pduuid, Environment environment) {
        Repository repository = environment.get(Repository.class);
        Publisher servicePublisher = environment.get(Publisher.class);
        BpelProcess bpelProcess = repository.removeProcess(pduuid);
        if (bpelProcess == null) {
            throw new OrchestraRuntimeException("Problem during undeployment : process " + pduuid + " not found");
        }
        List<BpelExecution> runningInstances = repository.getInstances(bpelProcess.getQName());
        if (runningInstances != null && !runningInstances.isEmpty()) {
            throw new OrchestraRuntimeException("Problem during undeployment: some instances  of process " + pduuid + " are still running");
        }
        servicePublisher.unpublishServices(bpelProcess, environment);
        EnvTool.getRecorder().recordProcessUndeployed(bpelProcess.getUUID());
        ProcessFullDefinition processDefinition = EnvTool.getQuerier().getProcessDefinition(bpelProcess.getUUID());
        UndeployedProcessHandler handler = EnvTool.get(UndeployedProcessHandler.class, "undeployed-process-handler");
        handler.handleUndeployedProcess(processDefinition);
        Misc.log(Level.INFO, "BPEL process %s undeployed.", pduuid);
    }

    public void redeploy(BpelProcess process, Environment environment) {
        Misc.log(Level.INFO, "Redeploying services for process %s", process.getQName());
        Publisher publisher = environment.get(Publisher.class);
        publisher.republishServices(process, environment);
    }
}

