/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.facade.runtime.full.impl;

import java.util.Date;
import org.ow2.orchestra.facade.runtime.ActivityState;
import org.ow2.orchestra.facade.runtime.RuntimeRecord;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.facade.uuid.ProcessInstanceUUID;
import org.ow2.orchestra.util.Misc;

public abstract class RuntimeRecordFullImpl
implements RuntimeRecord {
    private static final long serialVersionUID = -634690080367047966L;
    protected Date startedDate;
    protected Date endedDate;
    protected ProcessDefinitionUUID processUUID;
    protected ProcessInstanceUUID instanceUUID;
    protected ActivityState activityState;

    protected RuntimeRecordFullImpl() {
    }

    protected RuntimeRecordFullImpl(ProcessDefinitionUUID processUUID, ProcessInstanceUUID instanceUUID) {
        Misc.checkArgsNotNull(processUUID, instanceUUID);
        this.processUUID = processUUID;
        this.instanceUUID = instanceUUID;
        this.startedDate = new Date();
        this.activityState = ActivityState.RUNNING;
        this.endedDate = null;
    }

    protected RuntimeRecordFullImpl(RuntimeRecord src) {
        Misc.checkArgsNotNull(src);
        this.processUUID = src.getProcessDefinitionUUID();
        this.instanceUUID = src.getProcessInstanceUUID();
        this.startedDate = new Date(src.getStartedDate().getTime());
        this.activityState = src.getState();
        if (src.getEndedDate() != null) {
            this.endedDate = src.getEndedDate();
        }
    }

    public ProcessDefinitionUUID getProcessDefinitionUUID() {
        return this.processUUID;
    }

    public ProcessInstanceUUID getProcessInstanceUUID() {
        return this.instanceUUID;
    }

    public Date getEndedDate() {
        return this.endedDate;
    }

    public Date getStartedDate() {
        return this.startedDate;
    }

    public void end(ActivityState finishedState) {
        if (this.endedDate != null) {
            Misc.unreachableStatement(this + " already ended with state " + (Object)((Object)this.activityState));
        }
        this.endedDate = new Date();
        this.activityState = finishedState;
    }

    public int hashCode() {
        return this.getProcessDefinitionUUID().hashCode();
    }

    public ActivityState getState() {
        return this.activityState;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        RuntimeRecordFullImpl other = (RuntimeRecordFullImpl)obj;
        if (!this.getState().equals((Object)other.getState())) {
            return false;
        }
        if (!other.processUUID.equals(this.processUUID)) {
            return false;
        }
        return other.instanceUUID.equals(this.instanceUUID);
    }
}

