/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.pvm.internal.jobexecutor;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.ow2.orchestra.pvm.PvmException;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.env.Transaction;
import org.ow2.orchestra.pvm.internal.cmd.Command;
import org.ow2.orchestra.pvm.internal.job.JobImpl;
import org.ow2.orchestra.pvm.internal.jobexecutor.DeadJobHandler;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobAddedNotification;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobExecutor;
import org.ow2.orchestra.pvm.internal.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExceptionHandler
implements Command<Object> {
    private static final Log LOG = Log.getLog(JobExceptionHandler.class.getName());
    private static final long serialVersionUID = 1L;
    protected long jobDbid;
    protected JobImpl<?> job;
    protected Throwable exception;

    public JobExceptionHandler(long jobDbid, Throwable exception) {
        this.jobDbid = jobDbid;
        this.exception = exception;
    }

    public JobExceptionHandler(JobImpl<?> job, Throwable exception) {
        this.jobDbid = job.getDbid();
        this.job = job;
        this.exception = exception;
    }

    @Override
    public Object execute(Environment environment) {
        LOG.debug("handling jobImpl " + this.jobDbid + " exception: " + this.exception.getMessage());
        if (this.job == null) {
            JobDbSession session = environment.get(JobDbSession.class);
            if (session == null) {
                throw new PvmException("no job-session configured to handle job");
            }
            this.job = session.get(JobImpl.class, this.jobDbid);
        }
        StringWriter sw = new StringWriter();
        this.exception.printStackTrace(new PrintWriter(sw));
        if (this.job != null) {
            int decrementedRetries = this.job.getRetries() - 1;
            LOG.debug("decrementing retries to " + decrementedRetries + " for " + this.job);
            this.job.setRetries(decrementedRetries);
            this.job.setException(sw.toString());
            LOG.debug("unlocking " + this.job);
            this.job.setLockOwner(null);
            this.job.setLockExpirationTime(null);
            JobExecutor jobExecutor = environment.get(JobExecutor.class);
            if (decrementedRetries == 0) {
                DeadJobHandler deadJobHandler = jobExecutor.getDeadJobHandler();
                if (deadJobHandler != null) {
                    deadJobHandler.handleDeadJob(this.job);
                }
            } else {
                Transaction transaction = environment.get(Transaction.class);
                if (transaction != null && jobExecutor != null) {
                    LOG.trace("registering job executor notifier with " + transaction);
                    transaction.registerSynchronization(new JobAddedNotification(jobExecutor));
                }
            }
        }
        return null;
    }
}

