/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import org.ow2.orchestra.definition.BpelProcess;
import org.ow2.orchestra.facade.exception.OrchestraRuntimeException;
import org.ow2.orchestra.facade.uuid.ProcessDefinitionUUID;
import org.ow2.orchestra.pvm.env.Environment;
import org.ow2.orchestra.pvm.internal.jobexecutor.JobDbSession;
import org.ow2.orchestra.runtime.BpelExecution;
import org.ow2.orchestra.services.BpelMessageImpl;
import org.ow2.orchestra.services.ExecElementToSignal;
import org.ow2.orchestra.services.Receiver;
import org.ow2.orchestra.services.SignalExecUtil;
import org.ow2.orchestra.services.itf.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncFindExecToSignal
extends BpelMessageImpl<Boolean> {
    protected AsyncFindExecToSignal() {
    }

    public AsyncFindExecToSignal(BpelExecution instance, ProcessDefinitionUUID processUUID) {
        this.processInstance = instance.getProcessInstance();
        this.execution = instance.getProcessInstance();
        this.processUUID = processUUID;
    }

    @Override
    public Boolean execute(Environment environment) {
        JobDbSession dbSession;
        BpelExecution instance = (BpelExecution)this.getProcessInstance();
        ExecElementToSignal execElt = null;
        Repository repository = environment.get(Repository.class);
        BpelProcess bpelProcess = repository.lockProcess(this.processUUID);
        if ((instance = repository.getUpdatedExecution(instance)) != null && !instance.isEnded() && (execElt = Receiver.findExecutionToSignal(bpelProcess, instance)) != null) {
            SignalExecUtil.execute(environment, execElt.getBpelExecution(), execElt.getReceivingElement(), execElt.getPendingMessage());
        }
        if ((dbSession = environment.get(JobDbSession.class)) == null) {
            throw new OrchestraRuntimeException("no " + JobDbSession.class.getName() + " in environment");
        }
        dbSession.delete(this);
        return true;
    }
}

