/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.orchestra.services;

import org.ow2.orchestra.runtime.ScopeRuntime;
import org.ow2.orchestra.services.OperationKey;

public class ReplierKey {
    protected OperationKey operationKey;
    protected String messageExchange;
    protected String scopeRuntimeUUID;

    protected ReplierKey() {
    }

    public ReplierKey(OperationKey operationKey, String messageExchange, ScopeRuntime scopeRuntime) {
        this.operationKey = operationKey;
        this.messageExchange = messageExchange;
        this.scopeRuntimeUUID = scopeRuntime.getUuid();
    }

    public int hashCode() {
        int hash = this.getOperationKey().hashCode() + 37 * this.getScopeRuntimeUUID().hashCode() + 1369 * this.messageExchange.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ReplierKey)) {
            return false;
        }
        ReplierKey other = (ReplierKey)obj;
        OperationKey otherOpKey = other.getOperationKey();
        return otherOpKey.equals(this.operationKey) && other.getMessageExchange().equals(this.messageExchange) && this.scopeRuntimeUUID.equals(other.getScopeRuntimeUUID());
    }

    public OperationKey getOperationKey() {
        return this.operationKey;
    }

    public String getMessageExchange() {
        return this.messageExchange;
    }

    public String getScopeRuntimeUUID() {
        return this.scopeRuntimeUUID;
    }

    public String toString() {
        String st = "ReplierKey : OperationKey = " + this.operationKey.toString() + ", Scope = " + this.scopeRuntimeUUID;
        if (this.messageExchange != null) {
            st = st + ", MessageExchange = " + this.messageExchange;
        }
        return st;
    }
}

